/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity.base;

import es.degrassi.mmreborn.common.data.Config;
import es.degrassi.mmreborn.common.entity.base.BlockEntitySynchronized;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineEntity;
import es.degrassi.mmreborn.common.entity.base.IAutoInputEntity;
import es.degrassi.mmreborn.common.entity.base.IAutoOutputEntity;
import es.degrassi.mmreborn.common.network.server.SUpdateMachineColorPacket;
import es.degrassi.mmreborn.common.registration.EntityRegistration;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ColorableMachineComponentEntity
extends BlockEntitySynchronized
implements ColorableMachineEntity {
    private int definedColor = Config.machineColor;
    protected boolean shouldAutoOutput = false;
    protected boolean shouldAutoInput = false;
    protected final Set<BlockPos> controllerPosSet = new HashSet<BlockPos>();

    public ColorableMachineComponentEntity(BlockPos pos, BlockState blockState) {
        this(EntityRegistration.COLORABLE_MACHINE.get(), pos, blockState);
    }

    public ColorableMachineComponentEntity(BlockEntityType<?> entityType, BlockPos pos, BlockState blockState) {
        super(entityType, pos, blockState);
    }

    @Override
    public int getMachineColor() {
        return this.definedColor;
    }

    @Override
    public void setMachineColor(int newColor) {
        this.setChanged();
        this.definedColor = newColor;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineColorPacket(newColor, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        if (this instanceof IAutoOutputEntity) {
            this.shouldAutoOutput = nbt.getBoolean("shouldAutoOutput");
        }
        if (this instanceof IAutoInputEntity) {
            this.shouldAutoInput = nbt.getBoolean("shouldAutoInput");
        }
        if (nbt.contains("casingColor")) {
            this.definedColor = nbt.getInt("casingColor");
            return;
        }
        this.definedColor = Config.machineColor;
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.saveAdditional(nbt, pRegistries);
        if (this instanceof IAutoOutputEntity) {
            nbt.putBoolean("shouldAutoOutput", this.shouldAutoOutput);
        }
        if (this instanceof IAutoInputEntity) {
            nbt.putBoolean("shouldAutoInput", this.shouldAutoInput);
        }
        nbt.putInt("casingColor", this.definedColor);
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            if (this.getLevel() != null && this.getLevel().isClientSide()) {
                this.scheduleRenderUpdate();
            }
            return true;
        }
        return false;
    }

    public void scheduleRenderUpdate() {
        if (this.getLevel() != null) {
            if (this.getLevel().isClientSide()) {
                this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 8);
            } else {
                this.getLevel().blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 1, 0);
            }
        }
    }

    @Generated
    public boolean isShouldAutoOutput() {
        return this.shouldAutoOutput;
    }

    @Generated
    public void setShouldAutoOutput(boolean shouldAutoOutput) {
        this.shouldAutoOutput = shouldAutoOutput;
    }

    @Generated
    public boolean isShouldAutoInput() {
        return this.shouldAutoInput;
    }

    @Generated
    public void setShouldAutoInput(boolean shouldAutoInput) {
        this.shouldAutoInput = shouldAutoInput;
    }

    @Generated
    public Set<BlockPos> getControllerPosSet() {
        return this.controllerPosSet;
    }
}

