/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.controller.ControllerAccessible;
import es.degrassi.mmreborn.client.integration.athena.model.hatch.HatchTextureData;
import es.degrassi.mmreborn.common.block.prop.ParallelHatchSize;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.TextureableMachineEntity;
import es.degrassi.mmreborn.common.machine.MachineHatchType;
import es.degrassi.mmreborn.common.machine.component.ParallelComponent;
import es.degrassi.mmreborn.common.network.server.SUpdateMachineTexturePacket;
import es.degrassi.mmreborn.common.registration.EntityRegistration;
import es.degrassi.mmreborn.common.registration.MachineHatchTypeRegistration;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ParallelHatchEntity
extends ColorableMachineComponentEntity
implements MachineComponentEntity<ParallelComponent>,
ControllerAccessible,
TextureableMachineEntity {
    @Nullable
    private BlockPos controllerPos;
    protected ParallelHatchSize size;
    private ParallelComponent component;
    private ResourceLocation baseTexture;
    private ResourceLocation overlayTexture;
    private ResourceLocation defaultOverlayTexture;
    private static final ResourceLocation defaultBaseTexture = ModularMachineryReborn.rl("block/casing_plain");

    public ParallelHatchEntity(BlockPos pos, BlockState state, ParallelHatchSize size) {
        super(EntityRegistration.PARALLEL_HATCH.get(), pos, state);
        this.size = size;
        this.component = new ParallelComponent(size);
        this.overlayTexture = this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_parallel_hatch_" + size.getSerializedName());
        this.baseTexture = defaultBaseTexture;
    }

    public ParallelHatchEntity(BlockPos pos, BlockState state) {
        this(pos, state, ParallelHatchSize.BASIC);
    }

    @Override
    public void setControllerPos(BlockPos pos) {
        this.controllerPos = pos;
    }

    public void setCores(int cores) {
        this.component.setCores(cores, this.getLevel(), this.getBlockPos());
        if (this.getController() != null) {
            this.getController().getProcessor().updateActiveCores(cores);
        }
    }

    public int getCores() {
        return this.component.getContainerProvider();
    }

    public int getMaxCores() {
        return this.size.max;
    }

    @Override
    public ParallelComponent provideComponent() {
        return this.component;
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.size = ParallelHatchSize.value(compound.getString("size"));
        this.component = new ParallelComponent(this.size);
        if (compound.contains("controllerPos")) {
            this.controllerPos = BlockPos.of((long)compound.getLong("controllerPos"));
        }
        if (compound.contains("cores")) {
            this.setCores(compound.getInt("cores"));
        }
        this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_parallel_hatch_" + this.size.getSerializedName());
        this.baseTexture = compound.contains("baseTexture") ? ResourceLocation.parse((String)compound.getString("baseTexture")) : defaultBaseTexture;
        this.overlayTexture = compound.contains("overlayTexture") ? ResourceLocation.parse((String)compound.getString("overlayTexture")) : this.defaultOverlayTexture;
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.putString("size", this.size.getSerializedName());
        if (this.controllerPos != null) {
            compound.putLong("controllerPos", this.controllerPos.asLong());
        }
        compound.putInt("cores", this.component.getContainerProvider().intValue());
        compound.putInt("maxCores", this.getMaxCores());
        if (this.baseTexture != null) {
            compound.putString("baseTexture", this.baseTexture.toString());
        }
        if (this.overlayTexture != null) {
            compound.putString("overlayTexture", this.overlayTexture.toString());
        }
    }

    public ModelData getModelData() {
        return this.getModelDataBuilder("orientable").build();
    }

    @Override
    public HatchTextureData getTextureData(@NotNull String mode) {
        return MachineComponentEntity.super.getTextureData(mode).derive("bg_all", this.baseTexture, defaultBaseTexture, "ov_front", this.overlayTexture, this.defaultOverlayTexture, false);
    }

    @Override
    public ResourceLocation getMachineBaseTexture() {
        return this.baseTexture;
    }

    @Override
    public void setMachineBaseTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.baseTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.baseTexture, true, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public ResourceLocation getMachineOverlayTexture() {
        return this.overlayTexture;
    }

    @Override
    public void setMachineOverlayTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.overlayTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.overlayTexture, false, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public MachineHatchType getHatchType() {
        return (switch (this.size) {
            default -> throw new MatchException(null, null);
            case ParallelHatchSize.BASIC -> MachineHatchTypeRegistration.PARALLEL_HATCH_BASIC;
            case ParallelHatchSize.ADVANCED -> MachineHatchTypeRegistration.PARALLEL_HATCH_ADVANCED;
            case ParallelHatchSize.MEDIUM -> MachineHatchTypeRegistration.PARALLEL_HATCH_MEDIUM;
            case ParallelHatchSize.ULTIMATE -> MachineHatchTypeRegistration.PARALLEL_HATCH_ULTIMATE;
            case ParallelHatchSize.MAX -> MachineHatchTypeRegistration.PARALLEL_HATCH_MAX;
        }).get();
    }

    @Override
    public void resetTextures() {
        this.setMachineBaseTexture(defaultBaseTexture);
        this.setMachineOverlayTexture(this.defaultOverlayTexture);
    }

    @Override
    @Nullable
    @Generated
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Generated
    public ParallelHatchSize getSize() {
        return this.size;
    }

    @Generated
    public ParallelComponent getComponent() {
        return this.component;
    }

    @Generated
    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    @Generated
    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    @Generated
    public ResourceLocation getDefaultOverlayTexture() {
        return this.defaultOverlayTexture;
    }

    @Generated
    public void setSize(ParallelHatchSize size) {
        this.size = size;
    }

    @Generated
    public void setComponent(ParallelComponent component) {
        this.component = component;
    }

    @Generated
    public void setBaseTexture(ResourceLocation baseTexture) {
        this.baseTexture = baseTexture;
    }

    @Generated
    public void setOverlayTexture(ResourceLocation overlayTexture) {
        this.overlayTexture = overlayTexture;
    }

    @Generated
    public void setDefaultOverlayTexture(ResourceLocation defaultOverlayTexture) {
        this.defaultOverlayTexture = defaultOverlayTexture;
    }
}

