/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.client.machine.SoundManagerEntity;
import es.degrassi.mmreborn.api.controller.ComponentMapper;
import es.degrassi.mmreborn.api.controller.IMultiblockController;
import es.degrassi.mmreborn.api.controller.MMRWorldSavedData;
import es.degrassi.mmreborn.api.crafting.ComponentNotFoundException;
import es.degrassi.mmreborn.api.network.ISyncable;
import es.degrassi.mmreborn.api.network.ISyncableStuff;
import es.degrassi.mmreborn.api.network.syncable.IntegerSyncable;
import es.degrassi.mmreborn.api.network.syncable.NbtSyncable;
import es.degrassi.mmreborn.api.network.syncable.ResourceLocationSyncable;
import es.degrassi.mmreborn.api.network.syncable.StringSyncable;
import es.degrassi.mmreborn.client.integration.athena.model.controller.ControllerBakedModel;
import es.degrassi.mmreborn.client.integration.athena.model.controller.ControllerData;
import es.degrassi.mmreborn.common.crafting.helper.CraftingStatus;
import es.degrassi.mmreborn.common.crafting.modifier.ModifierReplacement;
import es.degrassi.mmreborn.common.data.MMRConfig;
import es.degrassi.mmreborn.common.entity.base.BlockEntityRestrictedTick;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineEntity;
import es.degrassi.mmreborn.common.entity.base.IClientTickEntity;
import es.degrassi.mmreborn.common.entity.base.IServerTickEntity;
import es.degrassi.mmreborn.common.entity.base.TextureableMachineEntity;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.common.manager.ComponentManager;
import es.degrassi.mmreborn.common.manager.crafting.MachineProcessor;
import es.degrassi.mmreborn.common.manager.crafting.MachineStatus;
import es.degrassi.mmreborn.common.network.server.SMachineUpdatePacket;
import es.degrassi.mmreborn.common.network.server.SSyncPauseStatePacket;
import es.degrassi.mmreborn.common.network.server.SUpdateCraftingStatusPacket;
import es.degrassi.mmreborn.common.registration.DataComponentRegistration;
import es.degrassi.mmreborn.common.registration.EntityRegistration;
import es.degrassi.mmreborn.common.util.RedstoneHelper;
import es.degrassi.mmreborn.common.util.Utils;
import es.degrassi.mmreborn.common.util.sound.AmbientSound;
import es.degrassi.mmreborn.common.util.sound.SoundManager;
import es.degrassi.mmreborn.common.util.sound.Sounds;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MachineControllerEntity
extends BlockEntityRestrictedTick
implements ComponentMapper,
ISyncableStuff,
IServerTickEntity,
IClientTickEntity,
SoundManagerEntity,
IMultiblockController {
    private CraftingStatus craftingStatus = CraftingStatus.MISSING_STRUCTURE;
    private boolean isPaused = false;
    private boolean formed = false;
    private ResourceLocation id = DynamicMachine.DUMMY.getRegistryName();
    private MachineStatus status = MachineStatus.IDLE;
    private Component errorMessage = Component.empty();
    private final ComponentList errorInfo = new ComponentList();
    private final ComponentManager componentManager;
    private final MachineProcessor processor;
    private int lastFocus;
    private SoundManager soundManager;
    private final long tickOffset = Utils.RAND.nextIntBetweenInclusive(0, 0x7FFFFFFE);
    private long lastCheckTick;
    private final Lock patternLock = new ReentrantLock();

    public MachineControllerEntity(BlockPos pos, BlockState state) {
        super(EntityRegistration.CONTROLLER.get(), pos, state);
        this.componentManager = new ComponentManager(this);
        this.processor = new MachineProcessor(this);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponentRegistration.MACHINE_DATA, (Object)this.getId());
    }

    public void setStatus(MachineStatus status, Component message) {
        if (this.status != status) {
            this.componentManager.getFoundComponentsList().forEach(component -> component.onStatusChanged(this.status, status, message));
            this.status = status;
            this.errorMessage = message;
            this.clearInfoErrors();
            this.setCraftingStatus(this.craftingByMachine(status));
            this.setChanged();
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                BlockPos pos = this.getBlockPos();
                sl.updateNeighborsAt(pos, this.getBlockState().getBlock());
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)sl, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new SUpdateCraftingStatusPacket(this.status, pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void setChanged() {
        if (this.level != null) {
            this.level.blockEntityChanged(this.worldPosition);
        }
    }

    private CraftingStatus craftingByMachine(MachineStatus status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case MachineStatus.IDLE -> CraftingStatus.NO_RECIPE;
            case MachineStatus.PAUSED -> this.craftingStatus;
            case MachineStatus.ERRORED -> CraftingStatus.failure(this.errorMessage);
            case MachineStatus.RUNNING -> CraftingStatus.working();
            case MachineStatus.MISSING_STRUCTURE -> CraftingStatus.MISSING_STRUCTURE;
        };
    }

    public void setStatus(MachineStatus status) {
        this.setStatus(status, (Component)Component.empty());
    }

    public ModelData getModelData() {
        return ModelData.builder().with(ControllerBakedModel.DATA, (Object)new ControllerData(this.getFoundMachine(), null)).build();
    }

    public DynamicMachine getFoundMachine() {
        return (DynamicMachine)ModularMachineryReborn.MACHINES.getOrDefault((Object)this.id, (Object)DynamicMachine.DUMMY);
    }

    public void tryPause() {
        this.setPaused(RedstoneHelper.getReceivingRedstone(this) > 0);
    }

    public void setPaused(boolean paused) {
        if (paused) {
            this.setStatus(MachineStatus.PAUSED);
        }
        assert (this.getLevel() != null);
        if (!this.getLevel().isClientSide && paused != this.isPaused) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.getLevel()), (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SSyncPauseStatePacket(paused, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.isPaused = paused;
    }

    @Override
    public void doClientTick() {
        AmbientSound sound;
        if (this.soundManager == null) {
            this.soundManager = new SoundManager(this.getBlockPos());
        }
        if (!this.soundManager.isCurrentlyPlaying(sound = this.getFoundMachine().getAmbientSound(this.status))) {
            if (sound == Sounds.DEFAULT.ambientSound()) {
                this.soundManager.setSound(null);
            } else {
                this.soundManager.setSound(sound);
            }
        }
        if (!this.soundManager.isPlaying()) {
            this.soundManager.play();
        }
    }

    @Override
    public void doRestrictedTick() {
        IServerTickEntity.super.doRestrictedTick();
        assert (this.level != null);
        if (!this.isFormed()) {
            MMRWorldSavedData mwsd = MMRWorldSavedData.getOrCreate((ServerLevel)this.level);
            if (!mwsd.containsAsyncLogicOrMapping(this)) {
                mwsd.addAsyncLogic(this);
            }
            if (!this.getStatus().isMissingStructure()) {
                this.setStatus(MachineStatus.MISSING_STRUCTURE);
            }
            return;
        }
        this.tryPause();
        if (this.isPaused()) {
            return;
        }
        this.level.getProfiler().push("Crafting Manager tick");
        try {
            this.processor.tick();
        }
        catch (ComponentNotFoundException e) {
            ModularMachineryReborn.LOGGER.error(e.getMessage());
        }
        this.level.getProfiler().pop();
    }

    public void setRemoved() {
        Level level;
        if (this.level != null && this.level.isClientSide() && this.soundManager != null) {
            this.soundManager.stop();
        }
        if ((level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.getFoundMachine().isDummy()) {
                MMRWorldSavedData.getOrCreate(serverLevel).removeAsyncLogic(this);
                MMRWorldSavedData.getOrCreate(serverLevel).removeMapping(this);
            }
        }
        super.setRemoved();
    }

    public void setMachine(ResourceLocation machine) {
        this.id = machine;
        this.formed = false;
        this.tryColorize(this.getBlockPos());
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SMachineUpdatePacket(machine, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ModularMachineryReborn.CONTROLLERS.add(this);
            try {
                ComponentManager.cache.get((Object)this);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            MMRWorldSavedData mwsd = MMRWorldSavedData.getOrCreate(l);
            mwsd.removeMapping(this);
            mwsd.removeAsyncLogic(this);
            mwsd.addAsyncLogic(this);
        }
        this.refreshClientData();
        this.setChanged();
    }

    @Override
    public int getMachineColor() {
        return this.getFoundMachine().getMachineColor();
    }

    private void tryColorize(BlockPos pos) {
        Object entity;
        if (this.getLevel() == null) {
            return;
        }
        BlockEntity te = this.getLevel().getBlockEntity(pos);
        AtomicBoolean shouldColor = new AtomicBoolean(true);
        if (te instanceof TextureableMachineEntity) {
            entity = (TextureableMachineEntity)te;
            entity.resetTextures();
            Optional.ofNullable(this.getFoundMachine().getFormedTextures().get(entity.getHatchType())).ifPresent(arg_0 -> MachineControllerEntity.lambda$tryColorize$2(shouldColor, (TextureableMachineEntity)entity, arg_0));
        }
        if (te instanceof ColorableMachineEntity) {
            entity = (ColorableMachineEntity)te;
            entity.setMachineColor(shouldColor.get() ? this.getMachineColor() : -1);
        }
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.craftingStatus = CraftingStatus.deserialize(compound.getCompound("status"), pRegistries);
        this.processor.deserialize(compound.getCompound("craftingManager"));
        this.isPaused = compound.getBoolean("isPaused");
        this.id = ResourceLocation.parse((String)compound.getString("machine"));
        this.setMachine(this.id);
        if (this.getLevel() instanceof ServerLevel) {
            this.onBlockStateChanged(this.getBlockPos(), this.getBlockState());
        }
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.put("status", (Tag)this.craftingStatus.serializeNBT(pRegistries));
        compound.putString("machine", this.id.toString());
        compound.put("craftingManager", (Tag)this.processor.serialize());
        compound.put("componentManager", (Tag)this.componentManager.serializeNBT(pRegistries));
        compound.putBoolean("isPaused", this.isPaused);
    }

    public void refreshClientData() {
        this.requestModelDataUpdate();
    }

    public List<MachineComponent<?>> getFoundComponents() {
        return this.componentManager.getFoundComponentsList();
    }

    @Override
    public Map<BlockPos, Optional<MachineComponent<?>>> getFoundComponentsMap() {
        return this.componentManager.getFoundComponentsMap();
    }

    public List<ModifierReplacement> getFoundModifiers() {
        return this.componentManager.getFoundModifiersList();
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        if (this.getLevel() == null) {
            return;
        }
        this.getErrorInfo().getStuffToSync(container);
        this.processor.getStuffToSync(container);
        this.componentManager.getStuffToSync(container);
        RegistryAccess registries = this.getLevel().registryAccess();
        container.accept(ResourceLocationSyncable.create(() -> this.id, s -> {
            this.id = s;
        }));
        container.accept(IntegerSyncable.create(() -> this.lastFocus, i -> {
            this.lastFocus = i;
        }));
        container.accept(NbtSyncable.create(() -> this.craftingStatus.serializeNBT((HolderLookup.Provider)registries), s -> {
            this.craftingStatus = CraftingStatus.deserialize(s, (HolderLookup.Provider)registries);
        }));
        container.accept(StringSyncable.create(() -> this.status.toString(), status -> {
            this.status = MachineStatus.value(status);
        }));
        container.accept(StringSyncable.create(() -> Component.Serializer.toJson((Component)this.errorMessage, (HolderLookup.Provider)registries), errorMessage -> {
            this.errorMessage = Component.Serializer.fromJson((String)errorMessage, (HolderLookup.Provider)registries);
        }));
    }

    public SoundType getInteractionSound() {
        return this.getFoundMachine().getInteractionSound(this.status);
    }

    @Override
    public boolean isPosInCache(BlockPos pos) {
        try {
            return ((List)ComponentManager.cache.get((Object)this)).contains(pos);
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    @Override
    public void onBlockStateChanged(BlockPos pos, BlockState newState) {
        if (this.level instanceof ServerLevel) {
            if (pos.equals((Object)this.getBlockPos())) {
                this.onStructureUnformed();
            } else if (this.getFoundMachine().getPattern().match((LevelReader)this.getLevel(), this.getBlockPos(), this.getFacing())) {
                this.onStructureFormed();
            } else {
                this.onStructureUnformed();
            }
        }
    }

    @Override
    public Direction getFacing() {
        return (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    @Override
    public void onStructureFormed() {
        this.formed = true;
        this.setStatus(MachineStatus.IDLE);
        this.componentManager.updateComponents();
        try {
            ((List)ComponentManager.cache.get((Object)this)).forEach(this::tryColorize);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    private List<Component> getStructureErrors() {
        return this.getFoundMachine().getPattern().getMinBlocksPredicate().getErrors();
    }

    public Component formatStructureErrors() {
        return (Component)this.getStructureErrors().stream().reduce(Component.empty(), MutableComponent::append, MutableComponent::append);
    }

    @Override
    public void onStructureUnformed() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            this.formed = false;
            this.setStatus(MachineStatus.MISSING_STRUCTURE);
            this.addErrorInfo(this.formatStructureErrors());
            this.componentManager.resetWithColor();
            this.processor.reset();
            MMRWorldSavedData mwsd = MMRWorldSavedData.getOrCreate(sl);
            mwsd.removeMapping(this);
            mwsd.removeAsyncLogic(this);
            mwsd.addAsyncLogic(this);
        }
    }

    @Override
    public void asyncCheckPattern(long periodID) {
        if (!this.formed && Utils.shouldRunPeriodicCheck(false, periodID, this.lastCheckTick, this.tickOffset, ((Integer)MMRConfig.get().checkStructureTicks.get()).intValue())) {
            this.lastCheckTick = periodID;
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                sl.getServer().execute(() -> {
                    this.patternLock.lock();
                    if (this.getFoundMachine().getPattern().match((LevelReader)this.getLevel(), this.getBlockPos(), this.getFacing())) {
                        this.onStructureFormed();
                        MMRWorldSavedData mwsd = MMRWorldSavedData.getOrCreate(sl);
                        mwsd.addMapping(this);
                        mwsd.removeAsyncLogic(this);
                    } else {
                        this.onStructureUnformed();
                    }
                    this.patternLock.unlock();
                });
            }
        }
    }

    public void addErrorInfo(Component translatable) {
        this.errorInfo.add(translatable);
    }

    public void clearInfoErrors() {
        this.errorInfo.clear();
    }

    @Generated
    public CraftingStatus getCraftingStatus() {
        return this.craftingStatus;
    }

    @Generated
    public boolean isPaused() {
        return this.isPaused;
    }

    @Generated
    public boolean isFormed() {
        return this.formed;
    }

    @Override
    @Generated
    public ResourceLocation getId() {
        return this.id;
    }

    @Generated
    public MachineStatus getStatus() {
        return this.status;
    }

    @Generated
    public Component getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public ComponentList getErrorInfo() {
        return this.errorInfo;
    }

    @Generated
    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Generated
    public MachineProcessor getProcessor() {
        return this.processor;
    }

    @Generated
    public int getLastFocus() {
        return this.lastFocus;
    }

    @Override
    @Generated
    public SoundManager getSoundManager() {
        return this.soundManager;
    }

    @Generated
    public long getTickOffset() {
        return this.tickOffset;
    }

    @Generated
    public long getLastCheckTick() {
        return this.lastCheckTick;
    }

    @Generated
    public void setFormed(boolean formed) {
        this.formed = formed;
    }

    @Generated
    public void setId(ResourceLocation id) {
        this.id = id;
    }

    @Generated
    public void setErrorMessage(Component errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public void setLastFocus(int lastFocus) {
        this.lastFocus = lastFocus;
    }

    @Generated
    public void setSoundManager(SoundManager soundManager) {
        this.soundManager = soundManager;
    }

    @Generated
    public void setLastCheckTick(long lastCheckTick) {
        this.lastCheckTick = lastCheckTick;
    }

    @Generated
    public void setCraftingStatus(CraftingStatus craftingStatus) {
        this.craftingStatus = craftingStatus;
    }

    @Generated
    public Lock getPatternLock() {
        return this.patternLock;
    }

    private static /* synthetic */ void lambda$tryColorize$2(AtomicBoolean shouldColor, TextureableMachineEntity entity, Pair p) {
        shouldColor.set((Boolean)p.getFirst());
        p.mapSecond(pair -> {
            ((Optional)pair.getFirst()).ifPresent(entity::setMachineBaseTexture);
            ((Optional)pair.getSecond()).ifPresent(entity::setMachineOverlayTexture);
            return null;
        });
    }

    public class ComponentList
    implements ISyncableStuff {
        private final Set<Component> components = Sets.newHashSet();
        private Component unified;

        protected ComponentList() {
        }

        @Override
        public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
            MutableComponent component = this.components.stream().collect(Component::empty, MutableComponent::append, MutableComponent::append);
            RegistryAccess registries = MachineControllerEntity.this.getLevel().registryAccess();
            if (this.components.isEmpty()) {
                component = null;
            }
            MutableComponent finalComponent = component;
            container.accept(StringSyncable.create(() -> finalComponent == null ? "" : Component.Serializer.toJson((Component)finalComponent, (HolderLookup.Provider)registries), c -> {
                this.unified = c.isEmpty() ? null : Component.Serializer.fromJson((String)c, (HolderLookup.Provider)registries);
            }));
        }

        public void add(Component component) {
            this.components.add(component);
        }

        public void clear() {
            this.components.clear();
            this.unified = null;
        }

        public Stream<Component> stream() {
            return this.components.stream();
        }

        public boolean isEmpty() {
            return this.unified == null && this.components.isEmpty();
        }

        public Component get() {
            return Optional.ofNullable(this.unified).orElse((Component)Component.empty());
        }
    }
}

