/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity;

import com.google.common.collect.Maps;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.capability.BasicFuelHandler;
import es.degrassi.mmreborn.api.capability.IFuelHandler;
import es.degrassi.mmreborn.api.controller.ControllerAccessible;
import es.degrassi.mmreborn.api.network.ISyncable;
import es.degrassi.mmreborn.api.network.ISyncableStuff;
import es.degrassi.mmreborn.api.network.syncable.BooleanSyncable;
import es.degrassi.mmreborn.api.network.syncable.LongSyncable;
import es.degrassi.mmreborn.client.integration.athena.model.hatch.HatchTextureData;
import es.degrassi.mmreborn.common.block.prop.FuelTankSize;
import es.degrassi.mmreborn.common.data.MMRConfig;
import es.degrassi.mmreborn.common.data.config.FuelTankConfig;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.entity.base.IAutoEntity;
import es.degrassi.mmreborn.common.entity.base.IAutoInputEntity;
import es.degrassi.mmreborn.common.entity.base.IServerTickEntity;
import es.degrassi.mmreborn.common.entity.base.ITickEntity;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.TextureableMachineEntity;
import es.degrassi.mmreborn.common.entity.base.TileInventory;
import es.degrassi.mmreborn.common.machine.MachineHatchType;
import es.degrassi.mmreborn.common.machine.component.FuelComponent;
import es.degrassi.mmreborn.common.manager.crafting.MachineStatus;
import es.degrassi.mmreborn.common.network.server.SUpdateMachineTexturePacket;
import es.degrassi.mmreborn.common.network.server.component.SUpdateFuelComponentPacket;
import es.degrassi.mmreborn.common.network.server.component.SUpdateItemComponentPacket;
import es.degrassi.mmreborn.common.registration.EntityRegistration;
import es.degrassi.mmreborn.common.registration.MachineHatchTypeRegistration;
import es.degrassi.mmreborn.common.util.IOInventory;
import es.degrassi.mmreborn.common.util.ItemSlot;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
public class FuelTankEntity
extends TileInventory
implements MachineComponentEntity<FuelComponent>,
ControllerAccessible,
TextureableMachineEntity,
ITickEntity,
IServerTickEntity,
ISyncableStuff,
IAutoInputEntity,
IAutoEntity<IItemHandler> {
    @Nullable
    private BlockPos controllerPos;
    private FuelTankSize size;
    private ResourceLocation baseTexture;
    private ResourceLocation overlayTexture;
    private ResourceLocation defaultOverlayTexture;
    private static final ResourceLocation defaultBaseTexture = ModularMachineryReborn.rl("block/casing_plain");
    private final IFuelHandler fuelHandler;
    private final long tickOffset = Utils.RAND.nextIntBetweenInclusive(0, 0x7FFFFFFE);
    private long lastCheckTick;
    private long lastCheckFuelTick;
    private final Map<Direction, BlockCapabilityCache<IItemHandler, Direction>> neighbourStorages = Maps.newEnumMap(Direction.class);

    private FuelTankEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, FuelTankSize size) {
        super(type, pos, state, 1);
        this.size = size;
        this.overlayTexture = this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_fueltank_" + size.getSerializedName());
        this.baseTexture = defaultBaseTexture;
        this.inventory.setListener(new IOInventory.IOInventoryChangedListener(){

            @Override
            public void onChange(int slot, @NotNull ItemStack stack) {
                FuelTankEntity.this.getControllerPosSet().forEach(p -> {
                    if (FuelTankEntity.this.getLevel() == null) {
                        return;
                    }
                    if (FuelTankEntity.this.getLevel().isClientSide()) {
                        return;
                    }
                    BlockEntity patt0$temp = FuelTankEntity.this.getLevel().getBlockEntity(p);
                    if (patt0$temp instanceof MachineControllerEntity) {
                        MachineControllerEntity controller = (MachineControllerEntity)patt0$temp;
                        controller.getProcessor().setMachineInventoryChanged();
                    }
                });
                Level level = FuelTankEntity.this.getLevel();
                if (level instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(FuelTankEntity.this.getBlockPos()), (CustomPacketPayload)new SUpdateItemComponentPacket(slot, stack, FuelTankEntity.this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }

            @Override
            public void onChange() {
                for (int slot = 0; slot < FuelTankEntity.this.inventory.getSlots(); ++slot) {
                    this.onChange(slot, FuelTankEntity.this.inventory.getStackInSlot(slot));
                }
            }
        });
        this.fuelHandler = new BasicFuelHandler(this.getInventory());
        this.fuelHandler.setMaxFuel(size.burnTimeCapacity);
        this.fuelHandler.setListener(() -> {
            if (this.getLevel() != null && !this.getLevel().isClientSide) {
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.getLevel()), (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateFuelComponentPacket(this.fuelHandler.getFuel(), this.fuelHandler.getMaxFuel(), this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (this.getController() != null) {
                this.getController().getProcessor().setMachineInventoryChanged();
            }
        });
        this.shouldAutoInput = true;
    }

    public FuelTankEntity(BlockPos pos, BlockState state, FuelTankSize size) {
        this(EntityRegistration.FUEL_TANK.get(), pos, state, size);
    }

    public FuelTankEntity(BlockPos pos, BlockState state) {
        this(pos, state, FuelTankSize.TINY);
    }

    @Override
    public void doRestrictedTick() {
        IServerTickEntity.super.doRestrictedTick();
        long gameTime = this.getLevel().getGameTime();
        if (((Boolean)FuelTankConfig.get().reduceFuelPerTick.get()).booleanValue()) {
            if (Utils.shouldRunPeriodicCheck(false, gameTime, this.lastCheckFuelTick, this.tickOffset, 1L) && this.getFuelHandler().getFuel() > 0L && (this.getController() == null || this.getController().getStatus() != MachineStatus.RUNNING)) {
                this.getFuelHandler().removeFuel(1L);
            }
            this.lastCheckFuelTick = gameTime;
        }
        if (!Utils.shouldRunPeriodicCheck(false, gameTime, this.lastCheckTick, this.tickOffset, ((Integer)MMRConfig.get().checkRecipeTicks.get()).intValue())) {
            return;
        }
        this.lastCheckTick = gameTime;
        this.getFuelHandler().tryBurnItem();
    }

    @Override
    public IOInventory buildInventory(int slots, int stackSize) {
        int[] inSlots = new int[slots];
        for (int i = 0; i < slots; ++i) {
            inSlots[i] = i;
        }
        return new IOInventory(inSlots, new int[0], stack -> stack.getBurnTime(RecipeType.SMELTING) > 0, stackSize, Direction.values());
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.getFuelHandler().deserialize(compound.getCompound("fuelTank"), pRegistries);
        this.size = FuelTankSize.value(compound.getString("busSize"));
        if (compound.contains("controllerPos")) {
            this.controllerPos = BlockPos.of((long)compound.getLong("controllerPos"));
        }
        this.baseTexture = compound.contains("baseTexture") ? ResourceLocation.parse((String)compound.getString("baseTexture")) : defaultBaseTexture;
        this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_fueltank_" + this.size.getSerializedName());
        this.overlayTexture = compound.contains("overlayTexture") ? ResourceLocation.parse((String)compound.getString("overlayTexture")) : this.defaultOverlayTexture;
        this.inventory.setListener(new IOInventory.IOInventoryChangedListener(){

            @Override
            public void onChange(int slot, @NotNull ItemStack stack) {
                FuelTankEntity.this.getControllerPosSet().forEach(p -> {
                    if (FuelTankEntity.this.getLevel() == null) {
                        return;
                    }
                    if (FuelTankEntity.this.getLevel().isClientSide()) {
                        return;
                    }
                    BlockEntity patt0$temp = FuelTankEntity.this.getLevel().getBlockEntity(p);
                    if (patt0$temp instanceof MachineControllerEntity) {
                        MachineControllerEntity controller = (MachineControllerEntity)patt0$temp;
                        controller.getProcessor().setMachineInventoryChanged();
                    }
                });
                Level level = FuelTankEntity.this.getLevel();
                if (level instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(FuelTankEntity.this.getBlockPos()), (CustomPacketPayload)new SUpdateItemComponentPacket(slot, stack, FuelTankEntity.this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }

            @Override
            public void onChange() {
                for (int slot = 0; slot < FuelTankEntity.this.inventory.getSlots(); ++slot) {
                    this.onChange(slot, FuelTankEntity.this.inventory.getStackInSlot(slot));
                }
            }
        });
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        CompoundTag fuelTag = new CompoundTag();
        this.getFuelHandler().serialize(fuelTag, pRegistries);
        compound.put("fuelTank", (Tag)fuelTag);
        compound.putString("busSize", this.size.getSerializedName());
        if (this.controllerPos != null) {
            compound.putLong("controllerPos", this.controllerPos.asLong());
        }
        if (this.baseTexture != null) {
            compound.putString("baseTexture", this.baseTexture.toString());
        }
        if (this.overlayTexture != null) {
            compound.putString("overlayTexture", this.overlayTexture.toString());
        }
    }

    public ModelData getModelData() {
        return this.getModelDataBuilder("all").build();
    }

    @Override
    public HatchTextureData getTextureData(String mode) {
        return MachineComponentEntity.super.getTextureData(mode).derive("bg_all", this.baseTexture, defaultBaseTexture, "ov_all", this.overlayTexture, this.defaultOverlayTexture, false);
    }

    @Override
    public ResourceLocation getMachineBaseTexture() {
        return this.baseTexture;
    }

    @Override
    public ResourceLocation getMachineOverlayTexture() {
        return this.overlayTexture;
    }

    @Override
    public void setMachineBaseTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.baseTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.baseTexture, true, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void setMachineOverlayTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.overlayTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.overlayTexture, false, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void resetTextures() {
        this.setMachineBaseTexture(defaultBaseTexture);
        this.setMachineOverlayTexture(this.defaultOverlayTexture);
    }

    @Override
    public MachineHatchType getHatchType() {
        return (switch (this.size) {
            default -> throw new MatchException(null, null);
            case FuelTankSize.TINY -> MachineHatchTypeRegistration.FUEL_TANK_TINY;
            case FuelTankSize.SMALL -> MachineHatchTypeRegistration.FUEL_TANK_SMALL;
            case FuelTankSize.NORMAL -> MachineHatchTypeRegistration.FUEL_TANK_NORMAL;
            case FuelTankSize.REINFORCED -> MachineHatchTypeRegistration.FUEL_TANK_REINFORCED;
            case FuelTankSize.BIG -> MachineHatchTypeRegistration.FUEL_TANK_BIG;
            case FuelTankSize.HUGE -> MachineHatchTypeRegistration.FUEL_TANK_HUGE;
        }).get();
    }

    @Override
    public FuelComponent provideComponent() {
        return new FuelComponent(this.getFuelHandler());
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(LongSyncable.create(this.getFuelHandler()::getFuel, this.getFuelHandler()::setFuel));
        container.accept(LongSyncable.create(this.getFuelHandler()::getMaxFuel, this.getFuelHandler()::setMaxFuel));
        container.accept(BooleanSyncable.create(this::isShouldAutoInput, this::setShouldAutoInput));
    }

    @Override
    public void tickAutoInput() {
        if (!this.shouldAutoInput) {
            return;
        }
        for (Direction side : Direction.values()) {
            IItemHandler neighbour = (IItemHandler)this.getNeighbour(Capabilities.ItemHandler.BLOCK, side);
            if (neighbour == null) continue;
            this.inventory.getInventory().stream().filter(ItemSlot::isInput).forEachOrdered(slot -> this.moveStacks(neighbour, (IItemHandler)slot, Integer.MAX_VALUE));
        }
    }

    protected void moveStacks(IItemHandler from, IItemHandler to, int maxAmount) {
        for (int i = 0; i < from.getSlots(); ++i) {
            ItemStack canExtract = from.extractItem(i, maxAmount, true);
            if (canExtract.isEmpty()) continue;
            ItemStack canInsert = ItemHandlerHelper.insertItemStacked((IItemHandler)to, (ItemStack)canExtract, (boolean)false);
            if (canInsert.isEmpty()) {
                from.extractItem(i, maxAmount, false);
                continue;
            }
            from.extractItem(i, canExtract.getCount() - canInsert.getCount(), false);
        }
    }

    @Override
    @Nullable
    @Generated
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Generated
    public FuelTankSize getSize() {
        return this.size;
    }

    @Generated
    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    @Generated
    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    @Generated
    public ResourceLocation getDefaultOverlayTexture() {
        return this.defaultOverlayTexture;
    }

    @Generated
    public IFuelHandler getFuelHandler() {
        return this.fuelHandler;
    }

    @Generated
    public long getTickOffset() {
        return this.tickOffset;
    }

    @Generated
    public long getLastCheckTick() {
        return this.lastCheckTick;
    }

    @Generated
    public long getLastCheckFuelTick() {
        return this.lastCheckFuelTick;
    }

    @Override
    @Generated
    public Map<Direction, BlockCapabilityCache<IItemHandler, Direction>> getNeighbourStorages() {
        return this.neighbourStorages;
    }

    @Override
    @Generated
    public void setControllerPos(@Nullable BlockPos controllerPos) {
        this.controllerPos = controllerPos;
    }

    @Generated
    public void setSize(FuelTankSize size) {
        this.size = size;
    }

    @Generated
    public void setBaseTexture(ResourceLocation baseTexture) {
        this.baseTexture = baseTexture;
    }

    @Generated
    public void setOverlayTexture(ResourceLocation overlayTexture) {
        this.overlayTexture = overlayTexture;
    }

    @Generated
    public void setDefaultOverlayTexture(ResourceLocation defaultOverlayTexture) {
        this.defaultOverlayTexture = defaultOverlayTexture;
    }

    @Generated
    public void setLastCheckTick(long lastCheckTick) {
        this.lastCheckTick = lastCheckTick;
    }

    @Generated
    public void setLastCheckFuelTick(long lastCheckFuelTick) {
        this.lastCheckFuelTick = lastCheckFuelTick;
    }

    @Generated
    public static ResourceLocation getDefaultBaseTexture() {
        return defaultBaseTexture;
    }
}

