/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity;

import es.degrassi.mmreborn.common.block.prop.EnergyHatchSize;
import es.degrassi.mmreborn.common.entity.base.EnergyHatchEntity;
import es.degrassi.mmreborn.common.entity.base.IAutoInputEntity;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.registration.EntityRegistration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyInputHatchEntity
extends EnergyHatchEntity
implements IAutoInputEntity {
    public EnergyInputHatchEntity(BlockPos pos, BlockState state) {
        super(EntityRegistration.ENERGY_INPUT_HATCH.get(), pos, state, EnergyHatchSize.TINY, IOType.INPUT);
    }

    public EnergyInputHatchEntity(BlockPos pos, BlockState state, EnergyHatchSize size) {
        super(EntityRegistration.ENERGY_INPUT_HATCH.get(), pos, state, size, IOType.INPUT);
    }

    @Override
    public void tickAutoInput() {
        if (!this.shouldAutoInput) {
            return;
        }
        long prevEnergy = this.energy;
        long transferCap = Math.min(this.size.transferLimit, this.getMaxEnergy() - this.energy);
        for (Direction face : Direction.values()) {
            if (transferCap > 0L) {
                int transferred = this.attemptFETransfer(face, this.convertDownEnergy(transferCap));
                transferCap -= (long)transferred;
                this.energy += (long)transferred;
            }
            if (transferCap <= 0L) break;
        }
        if (prevEnergy != this.energy) {
            this.markForUpdate();
        }
    }

    private int attemptFETransfer(Direction face, int maxTransferLeft) {
        IEnergyStorage ce;
        BlockPos at = this.getBlockPos().relative(face);
        int receivedEnergy = 0;
        BlockEntity te = this.level.getBlockEntity(at);
        if (te != null && !(te instanceof EnergyHatchEntity) && (ce = (IEnergyStorage)this.getNeighbour(Capabilities.EnergyStorage.BLOCK, face)) != null && ce.canExtract()) {
            try {
                receivedEnergy = ce.extractEnergy(maxTransferLeft, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return receivedEnergy;
    }
}

