/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.capability.EffectHandler;
import es.degrassi.mmreborn.api.controller.ControllerAccessible;
import es.degrassi.mmreborn.api.network.ISyncable;
import es.degrassi.mmreborn.api.network.ISyncableStuff;
import es.degrassi.mmreborn.api.network.syncable.BooleanSyncable;
import es.degrassi.mmreborn.client.integration.athena.model.hatch.HatchTextureData;
import es.degrassi.mmreborn.common.block.prop.EffectDispenserSize;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.IServerTickEntity;
import es.degrassi.mmreborn.common.entity.base.ITickEntity;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.TextureableMachineEntity;
import es.degrassi.mmreborn.common.machine.MachineHatchType;
import es.degrassi.mmreborn.common.machine.component.EffectComponent;
import es.degrassi.mmreborn.common.manager.crafting.MachineStatus;
import es.degrassi.mmreborn.common.network.server.SUpdateMachineTexturePacket;
import es.degrassi.mmreborn.common.registration.EntityRegistration;
import es.degrassi.mmreborn.common.registration.MachineHatchTypeRegistration;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EffectDispenserEntity
extends ColorableMachineComponentEntity
implements MachineComponentEntity<EffectComponent>,
ControllerAccessible,
TextureableMachineEntity,
ISyncableStuff,
ITickEntity,
IServerTickEntity {
    private BlockPos controllerPos;
    private ResourceLocation baseTexture;
    private ResourceLocation overlayTexture;
    private static final ResourceLocation defaultOverlayTexture = ModularMachineryReborn.rl("block/effect_dispenser");
    private static final ResourceLocation defaultBaseTexture = ModularMachineryReborn.rl("block/casing_plain");
    private EffectDispenserSize size;
    private final EffectHandler handler;

    public EffectDispenserEntity(BlockPos pos, BlockState blockState, EffectDispenserSize size) {
        super(EntityRegistration.EFFECT_DISPENSER.get(), pos, blockState);
        this.size = size;
        this.handler = new EffectHandler(this);
    }

    public EffectDispenserEntity(BlockPos pos, BlockState state) {
        this(pos, state, EffectDispenserSize.SMALL);
    }

    @Override
    public void doRestrictedTick() {
        IServerTickEntity.super.doRestrictedTick();
        if ((this.getController() == null || this.getController().getStatus() != MachineStatus.RUNNING) && this.getEffect().isPresent()) {
            this.getHandler().resetEffect();
        }
    }

    @Override
    @Nullable
    public EffectComponent provideComponent() {
        return new EffectComponent(this.handler);
    }

    @Override
    public ResourceLocation getMachineBaseTexture() {
        return this.baseTexture;
    }

    @Override
    public void setMachineBaseTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.baseTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.baseTexture, true, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public ResourceLocation getMachineOverlayTexture() {
        return this.overlayTexture;
    }

    @Override
    public void setMachineOverlayTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.overlayTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.overlayTexture, false, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public MachineHatchType getHatchType() {
        return (switch (this.size) {
            default -> throw new MatchException(null, null);
            case EffectDispenserSize.SMALL -> MachineHatchTypeRegistration.EFFECT_DISPENSER_SMALL;
            case EffectDispenserSize.MEDIUM -> MachineHatchTypeRegistration.EFFECT_DISPENSER_MEDIUM;
            case EffectDispenserSize.BIG -> MachineHatchTypeRegistration.EFFECT_DISPENSER_BIG;
        }).get();
    }

    @Override
    public void resetTextures() {
        this.setMachineBaseTexture(defaultBaseTexture);
        this.setMachineOverlayTexture(defaultOverlayTexture);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.size = EffectDispenserSize.value(nbt.getString("busSize"));
        if (nbt.contains("controllerPos")) {
            this.controllerPos = BlockPos.of((long)nbt.getLong("controllerPos"));
        }
        this.baseTexture = nbt.contains("baseTexture") ? ResourceLocation.parse((String)nbt.getString("baseTexture")) : defaultBaseTexture;
        this.overlayTexture = nbt.contains("overlayTexture") ? ResourceLocation.parse((String)nbt.getString("overlayTexture")) : defaultOverlayTexture;
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.putString("busSize", this.size.getSerializedName());
        if (this.controllerPos != null) {
            compound.putLong("controllerPos", this.controllerPos.asLong());
        }
        if (this.baseTexture != null) {
            compound.putString("baseTexture", this.baseTexture.toString());
        }
        if (this.overlayTexture != null) {
            compound.putString("overlayTexture", this.overlayTexture.toString());
        }
    }

    public ModelData getModelData() {
        return this.getModelDataBuilder("all").build();
    }

    @Override
    public HatchTextureData getTextureData(String mode) {
        return MachineComponentEntity.super.getTextureData(mode).derive("bg_all", this.baseTexture, defaultBaseTexture, "ov_all", this.overlayTexture, defaultOverlayTexture, false);
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(BooleanSyncable.create(this.handler::isApplyingEffect, this.handler::setApplyingEffect));
    }

    public boolean isApplyingEffect() {
        return this.handler.isApplyingEffect();
    }

    public Optional<MobEffectInstance> getEffect() {
        return Optional.ofNullable(this.handler.getEffect());
    }

    @Override
    @Generated
    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
    }

    @Generated
    public void setBaseTexture(ResourceLocation baseTexture) {
        this.baseTexture = baseTexture;
    }

    @Generated
    public void setOverlayTexture(ResourceLocation overlayTexture) {
        this.overlayTexture = overlayTexture;
    }

    @Generated
    public void setSize(EffectDispenserSize size) {
        this.size = size;
    }

    @Override
    @Generated
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Generated
    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    @Generated
    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    @Generated
    public static ResourceLocation getDefaultOverlayTexture() {
        return defaultOverlayTexture;
    }

    @Generated
    public static ResourceLocation getDefaultBaseTexture() {
        return defaultBaseTexture;
    }

    @Generated
    public EffectDispenserSize getSize() {
        return this.size;
    }

    @Generated
    public EffectHandler getHandler() {
        return this.handler;
    }
}

