/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity;

import com.google.common.collect.Maps;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.controller.ControllerAccessible;
import es.degrassi.mmreborn.api.network.ISyncable;
import es.degrassi.mmreborn.api.network.ISyncableStuff;
import es.degrassi.mmreborn.api.network.syncable.BooleanSyncable;
import es.degrassi.mmreborn.client.integration.athena.model.hatch.HatchTextureData;
import es.degrassi.mmreborn.common.block.prop.ItemDurabilityHatchSize;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.entity.base.IAutoEntity;
import es.degrassi.mmreborn.common.entity.base.IAutoInputEntity;
import es.degrassi.mmreborn.common.entity.base.IServerTickEntity;
import es.degrassi.mmreborn.common.entity.base.ITickEntity;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.TextureableMachineEntity;
import es.degrassi.mmreborn.common.entity.base.TileInventory;
import es.degrassi.mmreborn.common.machine.MachineHatchType;
import es.degrassi.mmreborn.common.machine.component.DurabilityComponent;
import es.degrassi.mmreborn.common.network.server.SUpdateMachineTexturePacket;
import es.degrassi.mmreborn.common.network.server.component.SUpdateItemComponentPacket;
import es.degrassi.mmreborn.common.registration.EntityRegistration;
import es.degrassi.mmreborn.common.registration.MachineHatchTypeRegistration;
import es.degrassi.mmreborn.common.util.IOInventory;
import es.degrassi.mmreborn.common.util.ItemSlot;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class DurabilityHatchEntity
extends TileInventory
implements MachineComponentEntity<DurabilityComponent>,
ControllerAccessible,
TextureableMachineEntity,
IAutoEntity<IItemHandler>,
IAutoInputEntity,
ISyncableStuff,
ITickEntity,
IServerTickEntity {
    private BlockPos controllerPos;
    private ItemDurabilityHatchSize size;
    private ResourceLocation baseTexture;
    private ResourceLocation overlayTexture;
    private ResourceLocation defaultOverlayTexture;
    private static final ResourceLocation defaultBaseTexture = ModularMachineryReborn.rl("block/casing_plain");
    private final Map<Direction, BlockCapabilityCache<IItemHandler, Direction>> neighbourStorages = Maps.newEnumMap(Direction.class);

    public DurabilityHatchEntity(BlockPos pos, BlockState blockState, ItemDurabilityHatchSize size) {
        super(EntityRegistration.ITEM_DURABILITY_HATCH.get(), pos, blockState, size.getSlotCount());
        this.size = size;
        this.overlayTexture = this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_durabilityhatch_" + size.getSerializedName());
        this.inventory.setListener(new IOInventory.IOInventoryChangedListener(){

            @Override
            public void onChange(int slot, @NotNull ItemStack stack) {
                DurabilityHatchEntity.this.getControllerPosSet().forEach(p -> {
                    if (DurabilityHatchEntity.this.getLevel() == null) {
                        return;
                    }
                    if (DurabilityHatchEntity.this.getLevel().isClientSide()) {
                        return;
                    }
                    BlockEntity patt0$temp = DurabilityHatchEntity.this.getLevel().getBlockEntity(p);
                    if (patt0$temp instanceof MachineControllerEntity) {
                        MachineControllerEntity controller = (MachineControllerEntity)patt0$temp;
                        controller.getProcessor().setMachineInventoryChanged();
                    }
                });
                Level level = DurabilityHatchEntity.this.getLevel();
                if (level instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(DurabilityHatchEntity.this.getBlockPos()), (CustomPacketPayload)new SUpdateItemComponentPacket(slot, stack, DurabilityHatchEntity.this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }

            @Override
            public void onChange() {
                for (int slot = 0; slot < DurabilityHatchEntity.this.inventory.getSlots(); ++slot) {
                    this.onChange(slot, DurabilityHatchEntity.this.inventory.getStackInSlot(slot));
                }
            }
        });
        this.shouldAutoInput = true;
    }

    public DurabilityHatchEntity(BlockPos pos, BlockState blockState) {
        this(pos, blockState, ItemDurabilityHatchSize.TINY);
    }

    @Override
    public IOInventory buildInventory(int slots, int stackSize) {
        int[] inSlots = new int[slots];
        for (int i = 0; i < slots; ++i) {
            inSlots[i] = i;
        }
        return new IOInventory(inSlots, new int[0], ItemStack::isDamageableItem, 1, Direction.values());
    }

    @Override
    @Nullable
    public DurabilityComponent provideComponent() {
        return new DurabilityComponent(this.getInventory());
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.size = ItemDurabilityHatchSize.value(compound.getString("busSize"));
        if (compound.contains("controllerPos")) {
            this.controllerPos = BlockPos.of((long)compound.getLong("controllerPos"));
        }
        this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_durabilityhatch_" + this.size.getSerializedName());
        this.baseTexture = compound.contains("baseTexture") ? ResourceLocation.parse((String)compound.getString("baseTexture")) : defaultBaseTexture;
        this.overlayTexture = compound.contains("overlayTexture") ? ResourceLocation.parse((String)compound.getString("overlayTexture")) : this.defaultOverlayTexture;
        this.inventory.setListener(new IOInventory.IOInventoryChangedListener(){

            @Override
            public void onChange(int slot, @NotNull ItemStack stack) {
                DurabilityHatchEntity.this.getControllerPosSet().forEach(p -> {
                    if (DurabilityHatchEntity.this.getLevel() == null) {
                        return;
                    }
                    if (DurabilityHatchEntity.this.getLevel().isClientSide()) {
                        return;
                    }
                    BlockEntity patt0$temp = DurabilityHatchEntity.this.getLevel().getBlockEntity(p);
                    if (patt0$temp instanceof MachineControllerEntity) {
                        MachineControllerEntity controller = (MachineControllerEntity)patt0$temp;
                        controller.getProcessor().setMachineInventoryChanged();
                    }
                });
                Level level = DurabilityHatchEntity.this.getLevel();
                if (level instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(DurabilityHatchEntity.this.getBlockPos()), (CustomPacketPayload)new SUpdateItemComponentPacket(slot, stack, DurabilityHatchEntity.this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }

            @Override
            public void onChange() {
                for (int slot = 0; slot < DurabilityHatchEntity.this.inventory.getSlots(); ++slot) {
                    this.onChange(slot, DurabilityHatchEntity.this.inventory.getStackInSlot(slot));
                }
            }
        });
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.putString("busSize", this.size.getSerializedName());
        if (this.controllerPos != null) {
            compound.putLong("controllerPos", this.controllerPos.asLong());
        }
        if (this.baseTexture != null) {
            compound.putString("baseTexture", this.baseTexture.toString());
        }
        if (this.overlayTexture != null) {
            compound.putString("overlayTexture", this.overlayTexture.toString());
        }
    }

    public ModelData getModelData() {
        return this.getModelDataBuilder("all").build();
    }

    @Override
    public HatchTextureData getTextureData(String mode) {
        return MachineComponentEntity.super.getTextureData(mode).derive("bg_all", this.baseTexture, defaultBaseTexture, "ov_all", this.overlayTexture, this.defaultOverlayTexture, false);
    }

    @Override
    public ResourceLocation getMachineBaseTexture() {
        return this.baseTexture;
    }

    @Override
    public ResourceLocation getMachineOverlayTexture() {
        return this.overlayTexture;
    }

    @Override
    public void setMachineBaseTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.baseTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.baseTexture, true, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void setMachineOverlayTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.overlayTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.overlayTexture, false, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void resetTextures() {
        this.setMachineBaseTexture(defaultBaseTexture);
        this.setMachineOverlayTexture(this.defaultOverlayTexture);
    }

    @Override
    public MachineHatchType getHatchType() {
        return (switch (this.size) {
            default -> throw new MatchException(null, null);
            case ItemDurabilityHatchSize.TINY -> MachineHatchTypeRegistration.DURABILITY_HATCH_TINY;
            case ItemDurabilityHatchSize.SMALL -> MachineHatchTypeRegistration.DURABILITY_HATCH_SMALL;
            case ItemDurabilityHatchSize.NORMAL -> MachineHatchTypeRegistration.DURABILITY_HATCH_NORMAL;
            case ItemDurabilityHatchSize.BIG -> MachineHatchTypeRegistration.DURABILITY_HATCH_BIG;
        }).get();
    }

    @Override
    public void tickAutoInput() {
        if (!this.shouldAutoInput) {
            return;
        }
        for (Direction side : Direction.values()) {
            IItemHandler neighbour = (IItemHandler)this.getNeighbour(Capabilities.ItemHandler.BLOCK, side);
            if (neighbour == null) continue;
            this.inventory.getInventory().stream().filter(ItemSlot::isInput).forEachOrdered(slot -> this.moveStacks(neighbour, (IItemHandler)slot, Integer.MAX_VALUE));
        }
    }

    protected void moveStacks(IItemHandler from, IItemHandler to, int maxAmount) {
        for (int i = 0; i < from.getSlots(); ++i) {
            ItemStack canExtract = from.extractItem(i, maxAmount, true);
            if (canExtract.isEmpty()) continue;
            ItemStack canInsert = ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)canExtract, (boolean)false);
            if (canInsert.isEmpty()) {
                from.extractItem(i, maxAmount, false);
                continue;
            }
            from.extractItem(i, canExtract.getCount() - canInsert.getCount(), false);
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(BooleanSyncable.create(this::isShouldAutoInput, this::setShouldAutoInput));
    }

    @Override
    @Generated
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Generated
    public ItemDurabilityHatchSize getSize() {
        return this.size;
    }

    @Generated
    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    @Generated
    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    @Generated
    public ResourceLocation getDefaultOverlayTexture() {
        return this.defaultOverlayTexture;
    }

    @Override
    @Generated
    public Map<Direction, BlockCapabilityCache<IItemHandler, Direction>> getNeighbourStorages() {
        return this.neighbourStorages;
    }

    @Override
    @Generated
    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
    }

    @Generated
    public void setBaseTexture(ResourceLocation baseTexture) {
        this.baseTexture = baseTexture;
    }

    @Generated
    public void setOverlayTexture(ResourceLocation overlayTexture) {
        this.overlayTexture = overlayTexture;
    }

    @Generated
    public static ResourceLocation getDefaultBaseTexture() {
        return defaultBaseTexture;
    }
}

