/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.controller.ControllerAccessible;
import es.degrassi.mmreborn.api.network.ISyncable;
import es.degrassi.mmreborn.api.network.ISyncableStuff;
import es.degrassi.mmreborn.client.integration.athena.model.hatch.HatchTextureData;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.TextureableMachineEntity;
import es.degrassi.mmreborn.common.machine.MachineHatchType;
import es.degrassi.mmreborn.common.machine.component.CommandComponent;
import es.degrassi.mmreborn.common.network.server.SUpdateMachineTexturePacket;
import es.degrassi.mmreborn.common.registration.EntityRegistration;
import es.degrassi.mmreborn.common.registration.MachineHatchTypeRegistration;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class CommandExecutionerEntity
extends ColorableMachineComponentEntity
implements MachineComponentEntity<CommandComponent>,
TextureableMachineEntity,
ControllerAccessible,
ISyncableStuff {
    private ResourceLocation baseTexture;
    private ResourceLocation overlayTexture;
    @Nullable
    private BlockPos controllerPos;
    private static final ResourceLocation defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_command_executioner");
    private static final ResourceLocation defaultBaseTexture = ModularMachineryReborn.rl("block/casing_plain");

    public CommandExecutionerEntity(BlockPos pos, BlockState blockState) {
        super(EntityRegistration.COMMAND_EXECUTIONER.get(), pos, blockState);
    }

    @Override
    public ResourceLocation getMachineBaseTexture() {
        return this.baseTexture;
    }

    @Override
    public void setMachineBaseTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.baseTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.baseTexture, true, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public ResourceLocation getMachineOverlayTexture() {
        return this.overlayTexture;
    }

    @Override
    public void setMachineOverlayTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.overlayTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.overlayTexture, false, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public MachineHatchType getHatchType() {
        return MachineHatchTypeRegistration.COMMAND_EXECUTIONER.get();
    }

    @Override
    public void resetTextures() {
        this.setMachineBaseTexture(defaultBaseTexture);
        this.setMachineOverlayTexture(defaultOverlayTexture);
    }

    public ModelData getModelData() {
        return this.getModelDataBuilder("all").build();
    }

    @Override
    @Nullable
    public CommandComponent provideComponent() {
        return new CommandComponent(this);
    }

    @Override
    public HatchTextureData getTextureData(@NotNull String mode) {
        return MachineComponentEntity.super.getTextureData(mode).derive("bg_all", this.baseTexture, defaultBaseTexture, "ov_all", this.overlayTexture, defaultOverlayTexture, false);
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        if (compound.contains("controllerPos")) {
            this.controllerPos = BlockPos.of((long)compound.getLong("controllerPos"));
        }
        this.baseTexture = compound.contains("baseTexture") ? ResourceLocation.parse((String)compound.getString("baseTexture")) : defaultBaseTexture;
        this.overlayTexture = compound.contains("overlayTexture") ? ResourceLocation.parse((String)compound.getString("overlayTexture")) : defaultOverlayTexture;
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        if (this.controllerPos != null) {
            compound.putLong("controllerPos", this.controllerPos.asLong());
        }
        if (this.baseTexture != null) {
            compound.putString("baseTexture", this.baseTexture.toString());
        }
        if (this.overlayTexture != null) {
            compound.putString("overlayTexture", this.overlayTexture.toString());
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
    }

    @Generated
    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    @Generated
    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    @Override
    @Nullable
    @Generated
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Generated
    public void setBaseTexture(ResourceLocation baseTexture) {
        this.baseTexture = baseTexture;
    }

    @Generated
    public void setOverlayTexture(ResourceLocation overlayTexture) {
        this.overlayTexture = overlayTexture;
    }

    @Override
    @Generated
    public void setControllerPos(@Nullable BlockPos controllerPos) {
        this.controllerPos = controllerPos;
    }
}

