/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.data.config;

import es.degrassi.mmreborn.common.block.prop.ParallelHatchSize;
import lombok.Generated;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ParallelHatchConfig {
    private static final ParallelHatchConfig INSTANCE;
    private static final ModConfigSpec spec;
    public final ModConfigSpec.ConfigValue<Integer> BASIC_parallel;
    public final ModConfigSpec.ConfigValue<Integer> MEDIUM_parallel;
    public final ModConfigSpec.ConfigValue<Integer> ADVANCED_parallel;
    public final ModConfigSpec.ConfigValue<Integer> ULTIMATE_parallel;
    public final ModConfigSpec.ConfigValue<Integer> MAX_parallel;

    public static ParallelHatchConfig get() {
        return INSTANCE;
    }

    public ParallelHatchConfig(ModConfigSpec.Builder builder) {
        builder.push(ParallelHatchSize.BASIC.getSerializedName());
        this.BASIC_parallel = builder.comment("Defined the max amount of running recipes").defineInRange("max", ParallelHatchSize.BASIC.defaultMax, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ParallelHatchSize.MEDIUM.getSerializedName());
        this.MEDIUM_parallel = builder.comment("Defined the max amount of running recipes").defineInRange("max", ParallelHatchSize.MEDIUM.defaultMax, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ParallelHatchSize.ADVANCED.getSerializedName());
        this.ADVANCED_parallel = builder.comment("Defined the max amount of running recipes").defineInRange("max", ParallelHatchSize.ADVANCED.defaultMax, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ParallelHatchSize.ULTIMATE.getSerializedName());
        this.ULTIMATE_parallel = builder.comment("Defined the max amount of running recipes").defineInRange("max", ParallelHatchSize.ULTIMATE.defaultMax, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ParallelHatchSize.MAX.getSerializedName());
        this.MAX_parallel = builder.comment("Defined the max amount of running recipes").defineInRange("max", ParallelHatchSize.MAX.defaultMax, 1, Integer.MAX_VALUE);
        builder.pop();
    }

    public int maxParallel(ParallelHatchSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case ParallelHatchSize.BASIC -> (Integer)this.BASIC_parallel.get();
            case ParallelHatchSize.MEDIUM -> (Integer)this.MEDIUM_parallel.get();
            case ParallelHatchSize.ADVANCED -> (Integer)this.ADVANCED_parallel.get();
            case ParallelHatchSize.ULTIMATE -> (Integer)this.ULTIMATE_parallel.get();
            case ParallelHatchSize.MAX -> (Integer)this.MAX_parallel.get();
        };
    }

    public int getMaxParallel() {
        int max = (Integer)this.BASIC_parallel.get();
        for (ParallelHatchSize size : ParallelHatchSize.values()) {
            int probable = this.maxParallel(size);
            if (probable <= max) continue;
            max = probable;
        }
        return max;
    }

    @Generated
    public static ModConfigSpec getSpec() {
        return spec;
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(ParallelHatchConfig::new);
        INSTANCE = (ParallelHatchConfig)pair.getLeft();
        spec = (ModConfigSpec)pair.getRight();
    }
}

