/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.data.config;

import es.degrassi.mmreborn.common.block.prop.ItemBusSize;
import lombok.Generated;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ItemBusConfig {
    private static final ItemBusConfig INSTANCE;
    private static final ModConfigSpec spec;
    public final ModConfigSpec.ConfigValue<Integer> itemSlotXOffset;
    public final ModConfigSpec.ConfigValue<Integer> itemSlotYOffset;
    public final ModConfigSpec.ConfigValue<Integer> TINY_item_size;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_item_size;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_item_size;
    public final ModConfigSpec.ConfigValue<Integer> REINFORCED_item_size;
    public final ModConfigSpec.ConfigValue<Integer> BIG_item_size;
    public final ModConfigSpec.ConfigValue<Integer> HUGE_item_size;
    public final ModConfigSpec.ConfigValue<Integer> LUDICROUS_item_size;
    public final ModConfigSpec.ConfigValue<Integer> TINY_stack_size;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_stack_size;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_stack_size;
    public final ModConfigSpec.ConfigValue<Integer> REINFORCED_stack_size;
    public final ModConfigSpec.ConfigValue<Integer> BIG_stack_size;
    public final ModConfigSpec.ConfigValue<Integer> HUGE_stack_size;
    public final ModConfigSpec.ConfigValue<Integer> LUDICROUS_stack_size;
    public final ModConfigSpec.ConfigValue<Integer> TINY_item_cols;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_item_cols;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_item_cols;
    public final ModConfigSpec.ConfigValue<Integer> REINFORCED_item_cols;
    public final ModConfigSpec.ConfigValue<Integer> BIG_item_cols;
    public final ModConfigSpec.ConfigValue<Integer> HUGE_item_cols;
    public final ModConfigSpec.ConfigValue<Integer> LUDICROUS_item_cols;

    public static ItemBusConfig get() {
        return INSTANCE;
    }

    public ItemBusConfig(ModConfigSpec.Builder builder) {
        builder.push("container");
        this.itemSlotXOffset = builder.comment("Defines the container X offset relative to top-left corner of the texture").defineInRange("xOffset", 8, 0, Integer.MAX_VALUE);
        this.itemSlotYOffset = builder.comment("Defines the container Y offset relative to top-left corner of the texture").defineInRange("yOffset", 8, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemBusSize.TINY.getSerializedName());
        this.TINY_item_size = builder.comment("Defines the slots number of item bus").defineInRange("slots", ItemBusSize.TINY.defaultSlots, 1, Integer.MAX_VALUE);
        this.TINY_item_cols = builder.comment("Defines the slot cols number of item bus").defineInRange("cols", ItemBusSize.TINY.defaultCols, 1, Integer.MAX_VALUE);
        this.TINY_stack_size = builder.comment("Defined the item bus slot max stack size").defineInRange("stackSize", ItemBusSize.TINY.defaultStackSize, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemBusSize.SMALL.getSerializedName());
        this.SMALL_item_size = builder.comment("Defines the slots number of item bus").defineInRange("slots", ItemBusSize.SMALL.defaultSlots, 1, Integer.MAX_VALUE);
        this.SMALL_item_cols = builder.comment("Defines the slot cols number of item bus").defineInRange("cols", ItemBusSize.SMALL.defaultCols, 1, Integer.MAX_VALUE);
        this.SMALL_stack_size = builder.comment("Defined the item bus slot max stack size").defineInRange("stackSize", ItemBusSize.SMALL.defaultStackSize, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemBusSize.NORMAL.getSerializedName());
        this.NORMAL_item_size = builder.comment("Defines the slots number of item bus").defineInRange("slots", ItemBusSize.NORMAL.defaultSlots, 1, Integer.MAX_VALUE);
        this.NORMAL_item_cols = builder.comment("Defines the slot cols number of item bus").defineInRange("cols", ItemBusSize.NORMAL.defaultCols, 1, Integer.MAX_VALUE);
        this.NORMAL_stack_size = builder.comment("Defined the item bus slot max stack size").defineInRange("stackSize", ItemBusSize.NORMAL.defaultStackSize, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemBusSize.REINFORCED.getSerializedName());
        this.REINFORCED_item_size = builder.comment("Defines the slots number of item bus").defineInRange("slots", ItemBusSize.REINFORCED.defaultSlots, 1, Integer.MAX_VALUE);
        this.REINFORCED_item_cols = builder.comment("Defines the slot cols number of item bus").defineInRange("cols", ItemBusSize.REINFORCED.defaultCols, 1, Integer.MAX_VALUE);
        this.REINFORCED_stack_size = builder.comment("Defined the item bus slot max stack size").defineInRange("stackSize", ItemBusSize.REINFORCED.defaultStackSize, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemBusSize.BIG.getSerializedName());
        this.BIG_item_size = builder.comment("Defines the slots number of item bus").defineInRange("slots", ItemBusSize.BIG.defaultSlots, 1, Integer.MAX_VALUE);
        this.BIG_item_cols = builder.comment("Defines the slot cols number of item bus").defineInRange("cols", ItemBusSize.BIG.defaultCols, 1, Integer.MAX_VALUE);
        this.BIG_stack_size = builder.comment("Defined the item bus slot max stack size").defineInRange("stackSize", ItemBusSize.BIG.defaultStackSize, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemBusSize.HUGE.getSerializedName());
        this.HUGE_item_size = builder.comment("Defines the slots number of item bus").defineInRange("slots", ItemBusSize.HUGE.defaultSlots, 1, Integer.MAX_VALUE);
        this.HUGE_item_cols = builder.comment("Defines the slot cols number of item bus").defineInRange("cols", ItemBusSize.HUGE.defaultCols, 1, Integer.MAX_VALUE);
        this.HUGE_stack_size = builder.comment("Defined the item bus slot max stack size").defineInRange("stackSize", ItemBusSize.HUGE.defaultStackSize, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemBusSize.LUDICROUS.getSerializedName());
        this.LUDICROUS_item_size = builder.comment("Defines the slots number of item bus").defineInRange("slots", ItemBusSize.LUDICROUS.defaultSlots, 1, Integer.MAX_VALUE);
        this.LUDICROUS_item_cols = builder.comment("Defines the slot cols number of item bus").defineInRange("cols", ItemBusSize.LUDICROUS.defaultCols, 1, Integer.MAX_VALUE);
        this.LUDICROUS_stack_size = builder.comment("Defined the item bus slot max stack size").defineInRange("stackSize", ItemBusSize.LUDICROUS.defaultStackSize, 1, Integer.MAX_VALUE);
        builder.pop();
    }

    public int itemSize(ItemBusSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case ItemBusSize.TINY -> (Integer)this.TINY_item_size.get();
            case ItemBusSize.SMALL -> (Integer)this.SMALL_item_size.get();
            case ItemBusSize.NORMAL -> (Integer)this.NORMAL_item_size.get();
            case ItemBusSize.REINFORCED -> (Integer)this.REINFORCED_item_size.get();
            case ItemBusSize.BIG -> (Integer)this.BIG_item_size.get();
            case ItemBusSize.HUGE -> (Integer)this.HUGE_item_size.get();
            case ItemBusSize.LUDICROUS -> (Integer)this.LUDICROUS_item_size.get();
        };
    }

    public int itemCols(ItemBusSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case ItemBusSize.TINY -> (Integer)this.TINY_item_cols.get();
            case ItemBusSize.SMALL -> (Integer)this.SMALL_item_cols.get();
            case ItemBusSize.NORMAL -> (Integer)this.NORMAL_item_cols.get();
            case ItemBusSize.REINFORCED -> (Integer)this.REINFORCED_item_cols.get();
            case ItemBusSize.BIG -> (Integer)this.BIG_item_cols.get();
            case ItemBusSize.HUGE -> (Integer)this.HUGE_item_cols.get();
            case ItemBusSize.LUDICROUS -> (Integer)this.LUDICROUS_item_cols.get();
        };
    }

    public int stackSize(ItemBusSize size) {
        return (Integer)(switch (size) {
            default -> throw new MatchException(null, null);
            case ItemBusSize.TINY -> this.TINY_stack_size;
            case ItemBusSize.SMALL -> this.SMALL_stack_size;
            case ItemBusSize.NORMAL -> this.NORMAL_stack_size;
            case ItemBusSize.REINFORCED -> this.REINFORCED_stack_size;
            case ItemBusSize.BIG -> this.BIG_stack_size;
            case ItemBusSize.HUGE -> this.HUGE_stack_size;
            case ItemBusSize.LUDICROUS -> this.LUDICROUS_stack_size;
        }).get();
    }

    @Generated
    public static ModConfigSpec getSpec() {
        return spec;
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(ItemBusConfig::new);
        INSTANCE = (ItemBusConfig)pair.getLeft();
        spec = (ModConfigSpec)pair.getRight();
    }
}

