/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.data.config;

import es.degrassi.mmreborn.common.block.prop.FuelTankSize;
import lombok.Generated;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class FuelTankConfig {
    private static final FuelTankConfig INSTANCE;
    private static final ModConfigSpec spec;
    public final ModConfigSpec.ConfigValue<Long> TINY_fuelCapacity;
    public final ModConfigSpec.ConfigValue<Long> SMALL_fuelCapacity;
    public final ModConfigSpec.ConfigValue<Long> NORMAL_fuelCapacity;
    public final ModConfigSpec.ConfigValue<Long> REINFORCED_fuelCapacity;
    public final ModConfigSpec.ConfigValue<Long> BIG_fuelCapacity;
    public final ModConfigSpec.ConfigValue<Long> HUGE_fuelCapacity;
    public final ModConfigSpec.ConfigValue<Integer> TINY_stack_size;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_stack_size;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_stack_size;
    public final ModConfigSpec.ConfigValue<Integer> REINFORCED_stack_size;
    public final ModConfigSpec.ConfigValue<Integer> BIG_stack_size;
    public final ModConfigSpec.ConfigValue<Integer> HUGE_stack_size;
    public final ModConfigSpec.ConfigValue<Boolean> reduceFuelPerTick;

    public static FuelTankConfig get() {
        return INSTANCE;
    }

    public FuelTankConfig(ModConfigSpec.Builder builder) {
        builder.push("General");
        this.reduceFuelPerTick = builder.comment("Weather the fuel tank should reduce its fuel when no recipe is running or not").define("reduceFuel", true);
        builder.pop();
        builder.push(FuelTankSize.TINY.getSerializedName());
        this.TINY_fuelCapacity = builder.comment("Defines the burntime capacity in ticks (1s = 20ticks)").defineInRange("fuelCapacity", FuelTankSize.TINY.defaultBurnTimeCapacity, 1L, Long.MAX_VALUE);
        this.TINY_stack_size = builder.comment("Defined the fuel tank slot max stack size").defineInRange("stackSize", FuelTankSize.TINY.defaultStackSize, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FuelTankSize.SMALL.getSerializedName());
        this.SMALL_fuelCapacity = builder.comment("Defines the burntime capacity in ticks (1s = 20ticks)").defineInRange("fuelCapacity", FuelTankSize.SMALL.defaultBurnTimeCapacity, 1L, Long.MAX_VALUE);
        this.SMALL_stack_size = builder.comment("Defined the fuel tank slot max stack size").defineInRange("stackSize", FuelTankSize.SMALL.defaultStackSize, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FuelTankSize.NORMAL.getSerializedName());
        this.NORMAL_fuelCapacity = builder.comment("Defines the burntime capacity in ticks (1s = 20ticks)").defineInRange("fuelCapacity", FuelTankSize.NORMAL.defaultBurnTimeCapacity, 1L, Long.MAX_VALUE);
        this.NORMAL_stack_size = builder.comment("Defined the fuel tank slot max stack size").defineInRange("stackSize", FuelTankSize.NORMAL.defaultStackSize, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FuelTankSize.REINFORCED.getSerializedName());
        this.REINFORCED_fuelCapacity = builder.comment("Defines the burntime capacity in ticks (1s = 20ticks)").defineInRange("fuelCapacity", FuelTankSize.REINFORCED.defaultBurnTimeCapacity, 1L, Long.MAX_VALUE);
        this.REINFORCED_stack_size = builder.comment("Defined the fuel tank slot max stack size").defineInRange("stackSize", FuelTankSize.REINFORCED.defaultStackSize, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FuelTankSize.BIG.getSerializedName());
        this.BIG_fuelCapacity = builder.comment("Defines the burntime capacity in ticks (1s = 20ticks)").defineInRange("fuelCapacity", FuelTankSize.BIG.defaultBurnTimeCapacity, 1L, Long.MAX_VALUE);
        this.BIG_stack_size = builder.comment("Defined the fuel tank slot max stack size").defineInRange("stackSize", FuelTankSize.BIG.defaultStackSize, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FuelTankSize.HUGE.getSerializedName());
        this.HUGE_fuelCapacity = builder.comment("Defines the burntime capacity in ticks (1s = 20ticks)").defineInRange("fuelCapacity", FuelTankSize.HUGE.defaultBurnTimeCapacity, 1L, Long.MAX_VALUE);
        this.HUGE_stack_size = builder.comment("Defined the fuel tank slot max stack size").defineInRange("stackSize", FuelTankSize.HUGE.defaultStackSize, 1, Integer.MAX_VALUE);
        builder.pop();
    }

    public long fuelCapacity(FuelTankSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case FuelTankSize.TINY -> (Long)this.TINY_fuelCapacity.get();
            case FuelTankSize.SMALL -> (Long)this.SMALL_fuelCapacity.get();
            case FuelTankSize.NORMAL -> (Long)this.NORMAL_fuelCapacity.get();
            case FuelTankSize.REINFORCED -> (Long)this.REINFORCED_fuelCapacity.get();
            case FuelTankSize.BIG -> (Long)this.BIG_fuelCapacity.get();
            case FuelTankSize.HUGE -> (Long)this.HUGE_fuelCapacity.get();
        };
    }

    public int stackSize(FuelTankSize size) {
        return (Integer)(switch (size) {
            default -> throw new MatchException(null, null);
            case FuelTankSize.TINY -> this.TINY_stack_size;
            case FuelTankSize.SMALL -> this.SMALL_stack_size;
            case FuelTankSize.NORMAL -> this.NORMAL_stack_size;
            case FuelTankSize.REINFORCED -> this.REINFORCED_stack_size;
            case FuelTankSize.BIG -> this.BIG_stack_size;
            case FuelTankSize.HUGE -> this.HUGE_stack_size;
        }).get();
    }

    @Generated
    public static ModConfigSpec getSpec() {
        return spec;
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(FuelTankConfig::new);
        INSTANCE = (FuelTankConfig)pair.getLeft();
        spec = (ModConfigSpec)pair.getRight();
    }
}

