/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.data.config;

import es.degrassi.mmreborn.common.block.prop.FluidHatchSize;
import lombok.Generated;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class FluidHatchConfig {
    private static final FluidHatchConfig INSTANCE;
    private static final ModConfigSpec spec;
    public final ModConfigSpec.ConfigValue<Integer> TINY_fluid_size;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_fluid_size;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_fluid_size;
    public final ModConfigSpec.ConfigValue<Integer> REINFORCED_fluid_size;
    public final ModConfigSpec.ConfigValue<Integer> BIG_fluid_size;
    public final ModConfigSpec.ConfigValue<Integer> HUGE_fluid_size;
    public final ModConfigSpec.ConfigValue<Integer> LUDICROUS_fluid_size;
    public final ModConfigSpec.ConfigValue<Integer> VACUUM_fluid_size;

    public static FluidHatchConfig get() {
        return INSTANCE;
    }

    public FluidHatchConfig(ModConfigSpec.Builder builder) {
        builder.push(FluidHatchSize.TINY.getSerializedName());
        this.TINY_fluid_size = builder.comment("Defines the tank size of fluid hatch in mB").defineInRange("size", FluidHatchSize.TINY.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FluidHatchSize.SMALL.getSerializedName());
        this.SMALL_fluid_size = builder.comment("Defines the tank size of fluid hatch in mB").defineInRange("size", FluidHatchSize.SMALL.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FluidHatchSize.NORMAL.getSerializedName());
        this.NORMAL_fluid_size = builder.comment("Defines the tank size of fluid hatch in mB").defineInRange("size", FluidHatchSize.NORMAL.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FluidHatchSize.REINFORCED.getSerializedName());
        this.REINFORCED_fluid_size = builder.comment("Defines the tank size of fluid hatch in mB").defineInRange("size", FluidHatchSize.REINFORCED.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FluidHatchSize.BIG.getSerializedName());
        this.BIG_fluid_size = builder.comment("Defines the tank size of fluid hatch in mB").defineInRange("size", FluidHatchSize.BIG.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FluidHatchSize.HUGE.getSerializedName());
        this.HUGE_fluid_size = builder.comment("Defines the tank size of fluid hatch in mB").defineInRange("size", FluidHatchSize.HUGE.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FluidHatchSize.LUDICROUS.getSerializedName());
        this.LUDICROUS_fluid_size = builder.comment("Defines the tank size of fluid hatch in mB").defineInRange("size", FluidHatchSize.LUDICROUS.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FluidHatchSize.VACUUM.getSerializedName());
        this.VACUUM_fluid_size = builder.comment("Defines the tank size of fluid hatch in mB").defineInRange("size", FluidHatchSize.VACUUM.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
    }

    public int fluidSize(FluidHatchSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case FluidHatchSize.TINY -> (Integer)this.TINY_fluid_size.get();
            case FluidHatchSize.SMALL -> (Integer)this.SMALL_fluid_size.get();
            case FluidHatchSize.NORMAL -> (Integer)this.NORMAL_fluid_size.get();
            case FluidHatchSize.REINFORCED -> (Integer)this.REINFORCED_fluid_size.get();
            case FluidHatchSize.BIG -> (Integer)this.BIG_fluid_size.get();
            case FluidHatchSize.HUGE -> (Integer)this.HUGE_fluid_size.get();
            case FluidHatchSize.LUDICROUS -> (Integer)this.LUDICROUS_fluid_size.get();
            case FluidHatchSize.VACUUM -> (Integer)this.VACUUM_fluid_size.get();
        };
    }

    @Generated
    public static ModConfigSpec getSpec() {
        return spec;
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(FluidHatchConfig::new);
        INSTANCE = (FluidHatchConfig)pair.getLeft();
        spec = (ModConfigSpec)pair.getRight();
    }
}

