/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.data.config;

import es.degrassi.mmreborn.common.block.prop.ExperienceHatchSize;
import lombok.Generated;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ExperienceHatchConfig {
    private static final ExperienceHatchConfig INSTANCE;
    private static final ModConfigSpec spec;
    public final ModConfigSpec.ConfigValue<Integer> TINY_experience_size;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_experience_size;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_experience_size;
    public final ModConfigSpec.ConfigValue<Integer> REINFORCED_experience_size;
    public final ModConfigSpec.ConfigValue<Integer> BIG_experience_size;
    public final ModConfigSpec.ConfigValue<Integer> HUGE_experience_size;
    public final ModConfigSpec.ConfigValue<Integer> LUDICROUS_experience_size;
    public final ModConfigSpec.ConfigValue<Integer> VACUUM_experience_size;

    public static ExperienceHatchConfig get() {
        return INSTANCE;
    }

    public ExperienceHatchConfig(ModConfigSpec.Builder builder) {
        builder.push(ExperienceHatchSize.TINY.getSerializedName());
        this.TINY_experience_size = builder.comment("Defines the Experience Hatch").defineInRange("capacity", ExperienceHatchSize.TINY.defaultCapacity, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ExperienceHatchSize.SMALL.getSerializedName());
        this.SMALL_experience_size = builder.comment("Defines the Experience Hatch").defineInRange("capacity", ExperienceHatchSize.SMALL.defaultCapacity, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ExperienceHatchSize.NORMAL.getSerializedName());
        this.NORMAL_experience_size = builder.comment("Defines the Experience Hatch").defineInRange("capacity", ExperienceHatchSize.NORMAL.defaultCapacity, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ExperienceHatchSize.REINFORCED.getSerializedName());
        this.REINFORCED_experience_size = builder.comment("Defines the Experience Hatch").defineInRange("capacity", ExperienceHatchSize.REINFORCED.defaultCapacity, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ExperienceHatchSize.BIG.getSerializedName());
        this.BIG_experience_size = builder.comment("Defines the Experience Hatch").defineInRange("capacity", ExperienceHatchSize.BIG.defaultCapacity, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ExperienceHatchSize.HUGE.getSerializedName());
        this.HUGE_experience_size = builder.comment("Defines the Experience Hatch").defineInRange("capacity", ExperienceHatchSize.HUGE.defaultCapacity, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ExperienceHatchSize.LUDICROUS.getSerializedName());
        this.LUDICROUS_experience_size = builder.comment("Defines the Experience Hatch").defineInRange("capacity", ExperienceHatchSize.LUDICROUS.defaultCapacity, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ExperienceHatchSize.VACUUM.getSerializedName());
        this.VACUUM_experience_size = builder.comment("Defines the Experience Hatch").defineInRange("capacity", ExperienceHatchSize.VACUUM.defaultCapacity, 1, Integer.MAX_VALUE);
        builder.pop();
    }

    public int experienceSize(ExperienceHatchSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case ExperienceHatchSize.TINY -> (Integer)this.TINY_experience_size.get();
            case ExperienceHatchSize.SMALL -> (Integer)this.SMALL_experience_size.get();
            case ExperienceHatchSize.NORMAL -> (Integer)this.NORMAL_experience_size.get();
            case ExperienceHatchSize.REINFORCED -> (Integer)this.REINFORCED_experience_size.get();
            case ExperienceHatchSize.BIG -> (Integer)this.BIG_experience_size.get();
            case ExperienceHatchSize.HUGE -> (Integer)this.HUGE_experience_size.get();
            case ExperienceHatchSize.LUDICROUS -> (Integer)this.LUDICROUS_experience_size.get();
            case ExperienceHatchSize.VACUUM -> (Integer)this.VACUUM_experience_size.get();
        };
    }

    @Generated
    public static ModConfigSpec getSpec() {
        return spec;
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(ExperienceHatchConfig::new);
        INSTANCE = (ExperienceHatchConfig)pair.getLeft();
        spec = (ModConfigSpec)pair.getRight();
    }
}

