/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.data.config;

import es.degrassi.mmreborn.client.util.EnergyDisplayUtil;
import es.degrassi.mmreborn.common.block.prop.EnergyHatchSize;
import lombok.Generated;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class EnergyHatchConfig {
    private static final EnergyHatchConfig INSTANCE;
    private static final ModConfigSpec spec;
    public final ModConfigSpec.ConfigValue<Integer> TINY_energy_size;
    public final ModConfigSpec.ConfigValue<Integer> TINY_energy_transferRate;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_energy_size;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_energy_transferRate;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_energy_size;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_energy_transferRate;
    public final ModConfigSpec.ConfigValue<Integer> REINFORCED_energy_size;
    public final ModConfigSpec.ConfigValue<Integer> REINFORCED_energy_transferRate;
    public final ModConfigSpec.ConfigValue<Integer> BIG_energy_size;
    public final ModConfigSpec.ConfigValue<Integer> BIG_energy_transferRate;
    public final ModConfigSpec.ConfigValue<Integer> HUGE_energy_size;
    public final ModConfigSpec.ConfigValue<Integer> HUGE_energy_transferRate;
    public final ModConfigSpec.ConfigValue<Integer> LUDICROUS_energy_size;
    public final ModConfigSpec.ConfigValue<Integer> LUDICROUS_energy_transferRate;
    public final ModConfigSpec.ConfigValue<Integer> ULTIMATE_energy_size;
    public final ModConfigSpec.ConfigValue<Integer> ULTIMATE_energy_transferRate;
    public final ModConfigSpec.ConfigValue<Boolean> energy_displayFETooltip;
    public final ModConfigSpec.ConfigValue<Boolean> energy_displayIC2EUTooltip;
    public final ModConfigSpec.ConfigValue<EnergyDisplayUtil.EnergyType> energy_type;

    public static EnergyHatchConfig get() {
        return INSTANCE;
    }

    public EnergyHatchConfig(ModConfigSpec.Builder builder) {
        builder.push(EnergyHatchSize.TINY.getSerializedName());
        this.TINY_energy_size = builder.comment("Energy storage size of the energy hatch.").defineInRange("size", EnergyHatchSize.TINY.defaultConfigurationEnergy, 1, Integer.MAX_VALUE);
        this.TINY_energy_transferRate = builder.comment("Defines the transfer limit for RF/FE things. \nIC2's transfer limit is defined by the voltage tier.").defineInRange("transfer_rate", EnergyHatchSize.TINY.defaultConfigurationTransferLimit, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(EnergyHatchSize.SMALL.getSerializedName());
        this.SMALL_energy_size = builder.comment("Energy storage size of the energy hatch.").defineInRange("size", EnergyHatchSize.SMALL.defaultConfigurationEnergy, 1, Integer.MAX_VALUE);
        this.SMALL_energy_transferRate = builder.comment("Defines the transfer limit for RF/FE things. \nIC2's transfer limit is defined by the voltage tier.").defineInRange("transfer_rate", EnergyHatchSize.SMALL.defaultConfigurationTransferLimit, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(EnergyHatchSize.NORMAL.getSerializedName());
        this.NORMAL_energy_size = builder.comment("Energy storage size of the energy hatch.").defineInRange("size", EnergyHatchSize.NORMAL.defaultConfigurationEnergy, 1, Integer.MAX_VALUE);
        this.NORMAL_energy_transferRate = builder.comment("Defines the transfer limit for RF/FE things. \nIC2's transfer limit is defined by the voltage tier.").defineInRange("transfer_rate", EnergyHatchSize.NORMAL.defaultConfigurationTransferLimit, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(EnergyHatchSize.REINFORCED.getSerializedName());
        this.REINFORCED_energy_size = builder.comment("Energy storage size of the energy hatch.").defineInRange("size", EnergyHatchSize.REINFORCED.defaultConfigurationEnergy, 1, Integer.MAX_VALUE);
        this.REINFORCED_energy_transferRate = builder.comment("Defines the transfer limit for RF/FE things. \nIC2's transfer limit is defined by the voltage tier.").defineInRange("transfer_rate", EnergyHatchSize.REINFORCED.defaultConfigurationTransferLimit, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(EnergyHatchSize.BIG.getSerializedName());
        this.BIG_energy_size = builder.comment("Energy storage size of the energy hatch.").defineInRange("size", EnergyHatchSize.BIG.defaultConfigurationEnergy, 1, Integer.MAX_VALUE);
        this.BIG_energy_transferRate = builder.comment("Defines the transfer limit for RF/FE things. \nIC2's transfer limit is defined by the voltage tier.").defineInRange("transfer_rate", EnergyHatchSize.BIG.defaultConfigurationTransferLimit, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(EnergyHatchSize.HUGE.getSerializedName());
        this.HUGE_energy_size = builder.comment("Energy storage size of the energy hatch.").defineInRange("size", EnergyHatchSize.HUGE.defaultConfigurationEnergy, 1, Integer.MAX_VALUE);
        this.HUGE_energy_transferRate = builder.comment("Defines the transfer limit for RF/FE things. \nIC2's transfer limit is defined by the voltage tier.").defineInRange("transfer_rate", EnergyHatchSize.HUGE.defaultConfigurationTransferLimit, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(EnergyHatchSize.LUDICROUS.getSerializedName());
        this.LUDICROUS_energy_size = builder.comment("Energy storage size of the energy hatch.").defineInRange("size", EnergyHatchSize.LUDICROUS.defaultConfigurationEnergy, 1, Integer.MAX_VALUE);
        this.LUDICROUS_energy_transferRate = builder.comment("Defines the transfer limit for RF/FE things. \nIC2's transfer limit is defined by the voltage tier.").defineInRange("transfer_rate", EnergyHatchSize.LUDICROUS.defaultConfigurationTransferLimit, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(EnergyHatchSize.ULTIMATE.getSerializedName());
        this.ULTIMATE_energy_size = builder.comment("Energy storage size of the energy hatch.").defineInRange("size", EnergyHatchSize.ULTIMATE.defaultConfigurationEnergy, 1, Integer.MAX_VALUE);
        this.ULTIMATE_energy_transferRate = builder.comment("Defines the transfer limit for RF/FE things. \nIC2's transfer limit is defined by the voltage tier.").defineInRange("transfer_rate", EnergyHatchSize.ULTIMATE.defaultConfigurationTransferLimit, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("Display");
        this.energy_displayFETooltip = builder.comment("Set to true, if the standard 'energy' FE (or RF) should be displayed in the tooltip of the energy hatch along with its transmission rates.").define("displayFETooltip", true);
        this.energy_displayIC2EUTooltip = builder.comment("Set to true, if IC2's energy EU should be displayed in the tooltip of the energy hatch. Will only have effect if IC2 is installed.").define("displayIC2EUTooltip", true);
        this.energy_type = builder.comment("Available options: 'FE', 'IC2_EU' - Default: FE - Set this to one of those 2 types to have GUI, recipe preview and energy be displayed in that type of energy in ALL ModularMachinery Reborn things.").defineEnum("type", (Enum)EnergyDisplayUtil.EnergyType.FE);
        builder.pop();
    }

    public long energySize(EnergyHatchSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case EnergyHatchSize.TINY -> ((Integer)this.TINY_energy_size.get()).intValue();
            case EnergyHatchSize.SMALL -> ((Integer)this.SMALL_energy_size.get()).intValue();
            case EnergyHatchSize.NORMAL -> ((Integer)this.NORMAL_energy_size.get()).intValue();
            case EnergyHatchSize.REINFORCED -> ((Integer)this.REINFORCED_energy_size.get()).intValue();
            case EnergyHatchSize.BIG -> ((Integer)this.BIG_energy_size.get()).intValue();
            case EnergyHatchSize.HUGE -> ((Integer)this.HUGE_energy_size.get()).intValue();
            case EnergyHatchSize.LUDICROUS -> ((Integer)this.LUDICROUS_energy_size.get()).intValue();
            case EnergyHatchSize.ULTIMATE -> ((Integer)this.ULTIMATE_energy_size.get()).intValue();
        };
    }

    public long energyLimit(EnergyHatchSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case EnergyHatchSize.TINY -> ((Integer)this.TINY_energy_transferRate.get()).intValue();
            case EnergyHatchSize.SMALL -> ((Integer)this.SMALL_energy_transferRate.get()).intValue();
            case EnergyHatchSize.NORMAL -> ((Integer)this.NORMAL_energy_transferRate.get()).intValue();
            case EnergyHatchSize.REINFORCED -> ((Integer)this.REINFORCED_energy_transferRate.get()).intValue();
            case EnergyHatchSize.BIG -> ((Integer)this.BIG_energy_transferRate.get()).intValue();
            case EnergyHatchSize.HUGE -> ((Integer)this.HUGE_energy_transferRate.get()).intValue();
            case EnergyHatchSize.LUDICROUS -> ((Integer)this.LUDICROUS_energy_transferRate.get()).intValue();
            case EnergyHatchSize.ULTIMATE -> ((Integer)this.ULTIMATE_energy_transferRate.get()).intValue();
        };
    }

    @Generated
    public static ModConfigSpec getSpec() {
        return spec;
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(EnergyHatchConfig::new);
        INSTANCE = (EnergyHatchConfig)pair.getLeft();
        spec = (ModConfigSpec)pair.getRight();
    }
}

