/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.data.config;

import es.degrassi.mmreborn.common.block.prop.EffectDispenserSize;
import lombok.Generated;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class EffectDispenserConfig {
    private static final EffectDispenserConfig INSTANCE;
    private static final ModConfigSpec spec;
    public final ModConfigSpec.ConfigValue<Integer> smallRadius;
    public final ModConfigSpec.ConfigValue<Integer> mediumRadius;
    public final ModConfigSpec.ConfigValue<Integer> bigRadius;
    public final ModConfigSpec.ConfigValue<Boolean> smallShowParticles;
    public final ModConfigSpec.ConfigValue<Boolean> mediumShowParticles;
    public final ModConfigSpec.ConfigValue<Boolean> bigShowParticles;

    public static EffectDispenserConfig get() {
        return INSTANCE;
    }

    public EffectDispenserConfig(ModConfigSpec.Builder builder) {
        builder.push(EffectDispenserSize.SMALL.getSerializedName());
        this.smallRadius = builder.comment(new String[]{"Defines the effect area radius in blocks", "This is ignored if the hatch is interdimensional"}).defineInRange("radius", EffectDispenserSize.SMALL.defaultRadius, 1, Integer.MAX_VALUE);
        this.smallShowParticles = builder.comment(new String[]{"Defines if this hatch should show the area effect in form of particles", "This is ignored if the hatch is interdimensional"}).define("showParticles", EffectDispenserSize.SMALL.defaultShowParticles);
        builder.pop();
        builder.push(EffectDispenserSize.MEDIUM.getSerializedName());
        this.mediumRadius = builder.comment(new String[]{"Defines the effect area radius in blocks", "This is ignored if the hatch is interdimensional"}).defineInRange("radius", EffectDispenserSize.MEDIUM.defaultRadius, 1, Integer.MAX_VALUE);
        this.mediumShowParticles = builder.comment(new String[]{"Defines if this hatch should show the area effect in form of particles", "This is ignored if the hatch is interdimensional"}).define("showParticles", EffectDispenserSize.MEDIUM.defaultShowParticles);
        builder.pop();
        builder.push(EffectDispenserSize.BIG.getSerializedName());
        this.bigRadius = builder.comment(new String[]{"Defines the effect area radius in blocks", "This is ignored if the hatch is interdimensional"}).defineInRange("radius", EffectDispenserSize.BIG.defaultRadius, 1, Integer.MAX_VALUE);
        this.bigShowParticles = builder.comment(new String[]{"Defines if this hatch should show the area effect in form of particles.", "This is ignored if the hatch is interdimensional"}).define("showParticles", EffectDispenserSize.BIG.defaultShowParticles);
        builder.pop();
    }

    public int radius(EffectDispenserSize size) {
        return (Integer)(switch (size) {
            default -> throw new MatchException(null, null);
            case EffectDispenserSize.SMALL -> this.smallRadius;
            case EffectDispenserSize.MEDIUM -> this.mediumRadius;
            case EffectDispenserSize.BIG -> this.bigRadius;
        }).get();
    }

    public boolean interdimensional(EffectDispenserSize size) {
        return false;
    }

    public boolean showParticles(EffectDispenserSize size) {
        return (Boolean)(switch (size) {
            default -> throw new MatchException(null, null);
            case EffectDispenserSize.SMALL -> this.smallShowParticles;
            case EffectDispenserSize.MEDIUM -> this.mediumShowParticles;
            case EffectDispenserSize.BIG -> this.bigShowParticles;
        }).get();
    }

    @Generated
    public static ModConfigSpec getSpec() {
        return spec;
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(EffectDispenserConfig::new);
        INSTANCE = (EffectDispenserConfig)pair.getLeft();
        spec = (ModConfigSpec)pair.getRight();
    }
}

