/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.data.config;

import es.degrassi.mmreborn.common.block.prop.ItemDurabilityHatchSize;
import lombok.Generated;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DurabilityHatchConfig {
    private static final DurabilityHatchConfig INSTANCE;
    private static final ModConfigSpec spec;
    public final ModConfigSpec.ConfigValue<Integer> TINY_durability_size;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_durability_size;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_durability_size;
    public final ModConfigSpec.ConfigValue<Integer> BIG_durability_size;
    public final ModConfigSpec.ConfigValue<Integer> TINY_durability_cols;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_durability_cols;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_durability_cols;
    public final ModConfigSpec.ConfigValue<Integer> BIG_durability_cols;
    public final ModConfigSpec.ConfigValue<Integer> TINY_stack_size;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_stack_size;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_stack_size;
    public final ModConfigSpec.ConfigValue<Integer> BIG_stack_size;

    public static DurabilityHatchConfig get() {
        return INSTANCE;
    }

    public DurabilityHatchConfig(ModConfigSpec.Builder builder) {
        builder.push(ItemDurabilityHatchSize.TINY.getSerializedName());
        this.TINY_durability_size = builder.comment("Defines the slots number of item durability hatch").defineInRange("slots", ItemDurabilityHatchSize.TINY.defaultSlots, 1, Integer.MAX_VALUE);
        this.TINY_durability_cols = builder.comment("Defines the slot cols number of item durability hatch").defineInRange("cols", ItemDurabilityHatchSize.TINY.defaultCols, 1, Integer.MAX_VALUE);
        this.TINY_stack_size = builder.comment("Defined the durability hatch slot max stack size").defineInRange("stackSize", ItemDurabilityHatchSize.TINY.defaultStackSize, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemDurabilityHatchSize.SMALL.getSerializedName());
        this.SMALL_durability_size = builder.comment("Defines the slots number of item durability hatch").defineInRange("slots", ItemDurabilityHatchSize.SMALL.defaultSlots, 1, Integer.MAX_VALUE);
        this.SMALL_durability_cols = builder.comment("Defines the slot cols number of item durability hatch").defineInRange("cols", ItemDurabilityHatchSize.SMALL.defaultCols, 1, Integer.MAX_VALUE);
        this.SMALL_stack_size = builder.comment("Defined the durability hatch slot max stack size").defineInRange("stackSize", ItemDurabilityHatchSize.SMALL.defaultStackSize, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemDurabilityHatchSize.NORMAL.getSerializedName());
        this.NORMAL_durability_size = builder.comment("Defines the slots number of item durability hatch").defineInRange("slots", ItemDurabilityHatchSize.NORMAL.defaultSlots, 1, Integer.MAX_VALUE);
        this.NORMAL_durability_cols = builder.comment("Defines the slot cols number of item durability hatch").defineInRange("cols", ItemDurabilityHatchSize.NORMAL.defaultCols, 1, Integer.MAX_VALUE);
        this.NORMAL_stack_size = builder.comment("Defined the durability hatch slot max stack size").defineInRange("stackSize", ItemDurabilityHatchSize.NORMAL.defaultStackSize, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemDurabilityHatchSize.BIG.getSerializedName());
        this.BIG_durability_size = builder.comment("Defines the slots number of item durability hatch").defineInRange("slots", ItemDurabilityHatchSize.BIG.defaultSlots, 1, Integer.MAX_VALUE);
        this.BIG_durability_cols = builder.comment("Defines the slot cols number of item durability hatch").defineInRange("cols", ItemDurabilityHatchSize.BIG.defaultCols, 1, Integer.MAX_VALUE);
        this.BIG_stack_size = builder.comment("Defined the durability hatch slot max stack size").defineInRange("stackSize", ItemDurabilityHatchSize.BIG.defaultStackSize, 1, Integer.MAX_VALUE);
        builder.pop();
    }

    public int durabilitySize(ItemDurabilityHatchSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case ItemDurabilityHatchSize.TINY -> (Integer)this.TINY_durability_size.get();
            case ItemDurabilityHatchSize.SMALL -> (Integer)this.SMALL_durability_size.get();
            case ItemDurabilityHatchSize.NORMAL -> (Integer)this.NORMAL_durability_size.get();
            case ItemDurabilityHatchSize.BIG -> (Integer)this.BIG_durability_size.get();
        };
    }

    public int durabilityCols(ItemDurabilityHatchSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case ItemDurabilityHatchSize.TINY -> (Integer)this.TINY_durability_cols.get();
            case ItemDurabilityHatchSize.SMALL -> (Integer)this.SMALL_durability_cols.get();
            case ItemDurabilityHatchSize.NORMAL -> (Integer)this.NORMAL_durability_cols.get();
            case ItemDurabilityHatchSize.BIG -> (Integer)this.BIG_durability_cols.get();
        };
    }

    public int stackSize(ItemDurabilityHatchSize size) {
        return (Integer)(switch (size) {
            default -> throw new MatchException(null, null);
            case ItemDurabilityHatchSize.TINY -> this.TINY_stack_size;
            case ItemDurabilityHatchSize.SMALL -> this.SMALL_stack_size;
            case ItemDurabilityHatchSize.NORMAL -> this.NORMAL_stack_size;
            case ItemDurabilityHatchSize.BIG -> this.BIG_stack_size;
        }).get();
    }

    @Generated
    public static ModConfigSpec getSpec() {
        return spec;
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(DurabilityHatchConfig::new);
        INSTANCE = (DurabilityHatchConfig)pair.getLeft();
        spec = (ModConfigSpec)pair.getRight();
    }
}

