/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.data;

import com.google.common.collect.Lists;
import es.degrassi.mmreborn.common.util.LoggingLevel;
import java.util.List;
import lombok.Generated;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class MMRConfig {
    private static final MMRConfig INSTANCE;
    private static final ModConfigSpec spec;
    public final ModConfigSpec.ConfigValue<LoggingLevel> debugLevel;
    public final ModConfigSpec.ConfigValue<Boolean> logMissingOptional;
    public final ModConfigSpec.ConfigValue<Boolean> logFirstEitherError;
    public final ModConfigSpec.ConfigValue<String> general_casing_color;
    public final ModConfigSpec.ConfigValue<String> chance_color;
    public final ModConfigSpec.ConfigValue<Integer> checkStructureTicks;
    public final ModConfigSpec.ConfigValue<Integer> checkRecipeTicks;
    public final ModConfigSpec.ConfigValue<Integer> maxParallel;
    public final ModConfigSpec.ConfigValue<Boolean> shouldReplace;
    public final ModConfigSpec.ConfigValue<Boolean> sendReplaceMessage;
    public final ModConfigSpec.ConfigValue<Boolean> sendMissingBlockMessage;
    public final ModConfigSpec.ConfigValue<Boolean> sendErrorMessage;
    public final ModConfigSpec.ConfigValue<Integer> structureRenderTime;
    public final ModConfigSpec.ConfigValue<Integer> blockTagCycleTime;
    public final ModConfigSpec.ConfigValue<String> machineDirectory;
    public final ModConfigSpec.ConfigValue<List<String>> modelFolders;

    public static MMRConfig get() {
        return INSTANCE;
    }

    public MMRConfig(ModConfigSpec.Builder builder) {
        builder.push("Logs");
        this.logMissingOptional = builder.comment("If true, all missing optional properties\nand their default values will be logged\nwhen parsing custom machines jsons.").define("log_missing_optional", false);
        this.logFirstEitherError = builder.comment("When parsing custom machines json files,\nsome properties can be read with 2 serializers.\nSet this to true to log when the first serializer throw an error,\neven if the second succeed.").define("log_first_either_error", false);
        this.debugLevel = builder.comment("Configure what logs will be printed in the custommachinery.log file.\nOnly logs with level higher or equal than selected will be printed.\nFATAL > ERROR > WARN > INFO > DEBUG > ALL").defineEnum("debug_level", (Enum)LoggingLevel.INFO);
        builder.pop();
        builder.push("General");
        this.general_casing_color = builder.comment("Defines the _default_ color for machine casings as items or blocks. (Hex color with alpha at start) Has to be defined both server and clientside!").define("general_casing_color", (Object)"#FFFF4900");
        this.chance_color = builder.comment("Defines the _default_ color for EMI/JEI chance text color. (Hex color without alpha) Has to be defined both server and clientside!").define("chance_color", (Object)"#FFFFFF");
        this.checkStructureTicks = builder.comment("Defines the time in ticks that the machine should check for a structure update.\n20 ticks = 1 second. Default: 5").defineInRange("check_structure_ticks", 5, 1, Integer.MAX_VALUE);
        this.checkRecipeTicks = builder.comment("Defines the time in ticks that the machine should check for a recipe update.\n20 ticks = 1 second. Default: 80").defineInRange("check_recipe_ticks", 20, 1, Integer.MAX_VALUE);
        this.maxParallel = builder.comment("Defines the number of max parallel recipes that can be run on multiblocks. If this number is below than any on [parallel hatch] config path, it will use the max value of them instead.").defineInRange("maxParallel", 256, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("Structure");
        this.shouldReplace = builder.comment("Defines if it should break and place the non-matching blocks on trying to place structure. Default: true").define("should_replace", true);
        this.sendReplaceMessage = builder.comment("Defines if should sent a message to the player for each replaced block. Default: true").define("replaceMessage", true);
        this.sendMissingBlockMessage = builder.comment("Defines if should sent a message to the player for each missing block. Default: true").define("missingBlockMessage", true);
        this.sendErrorMessage = builder.comment("Defines if should sent a message to the player for each error on place block. Default: true").define("errorMessage", true);
        builder.pop();
        builder.push("Rendering");
        this.structureRenderTime = builder.comment("The time in milliseconds the structure requirement\nstructure will render in world when clicking\non the icon in the jei recipe.").defineInRange("structure_render_time", 10000, 1, Integer.MAX_VALUE);
        this.blockTagCycleTime = builder.comment("The time in milliseconds each blocks will be shown\nwhen using a block tag in a structure.").defineInRange("block_tag_cycle_time", 1000, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("Directories");
        this.machineDirectory = builder.comment("A folder name where MMR will load machine structure json.\nThese folder must be under the \"data/<namespace>\" folder.").define("machine_directory", (Object)"machines");
        this.modelFolders = builder.comment("A list of folder names where MMR will load controller models json. These folders must be under the 'assets/namespace/models' folder.").define("model_folders", (Object)Lists.newArrayList((Object[])new String[]{"controller", "controllers"}));
        builder.pop();
    }

    @Generated
    public static ModConfigSpec getSpec() {
        return spec;
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(MMRConfig::new);
        INSTANCE = (MMRConfig)pair.getLeft();
        spec = (ModConfigSpec)pair.getRight();
    }
}

