/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.jei;

import com.google.common.collect.Lists;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementLootTable;
import es.degrassi.mmreborn.common.crafting.requirement.jei.JeiComponent;
import es.degrassi.mmreborn.common.integration.jei.category.MMRRecipeCategory;
import es.degrassi.mmreborn.common.machine.component.ItemComponent;
import es.degrassi.mmreborn.common.util.IOInventory;
import es.degrassi.mmreborn.common.util.LootTableHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class JeiLootTableComponent
extends JeiComponent<ResourceLocation, RecipeRequirement<ItemComponent, RequirementLootTable, IOInventory>> {
    public JeiLootTableComponent(RecipeRequirement<ItemComponent, RequirementLootTable, IOInventory> requirement) {
        super(requirement, 36, 0);
    }

    @Override
    public int getWidth() {
        return 18;
    }

    @Override
    public int getHeight() {
        return 18;
    }

    @Override
    public List<ResourceLocation> ingredients() {
        return Collections.singletonList(((RequirementLootTable)this.requirement.requirement()).getLootTable());
    }

    @Override
    public void setRecipe(MMRRecipeCategory category, IRecipeLayoutBuilder builder, MachineRecipe recipe, IFocusGroup focuses) {
        List<LootTableHelper.LootData> loots = LootTableHelper.getLootsForTable(((RequirementLootTable)this.requirement.requirement()).getLootTable());
        ArrayList ingredients = Lists.newArrayList(loots.stream().map(LootTableHelper.LootData::stack).toList());
        ((IRecipeSlotBuilder)builder.addSlot(this.role(), this.getPosition().x(), this.getPosition().y()).addItemStacks((List)ingredients)).addRichTooltipCallback((view, tooltips) -> {
            LootTableHelper.LootData data = view.getDisplayedIngredient().flatMap(ingredient -> loots.stream().filter(lootData -> ItemStack.isSameItemSameComponents((ItemStack)lootData.stack(), (ItemStack)((ItemStack)ingredient.getItemStack().get()))).findFirst()).orElse(null);
            if (data == null) {
                return;
            }
            if (data.chance() != 1.0) {
                double percentage = data.chance() * 100.0;
                if (percentage < (double)0.01f) {
                    tooltips.add((FormattedText)Component.translatable((String)("modular_machinery_reborn.ingredient.chance." + ((RequirementLootTable)this.requirement.requirement()).getMode().name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{"<0.01", "%"}));
                } else {
                    BigDecimal decimal = BigDecimal.valueOf(percentage).setScale(2, RoundingMode.HALF_UP);
                    if (decimal.scale() <= 0 || decimal.signum() == 0 || decimal.stripTrailingZeros().scale() <= 0) {
                        tooltips.add((FormattedText)Component.translatable((String)("modular_machinery_reborn.ingredient.chance." + ((RequirementLootTable)this.requirement.requirement()).getMode().name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{decimal.intValue(), "%"}));
                    } else {
                        tooltips.add((FormattedText)Component.translatable((String)("modular_machinery_reborn.ingredient.chance." + ((RequirementLootTable)this.requirement.requirement()).getMode().name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{decimal.doubleValue(), "%"}));
                    }
                }
                if (!data.rolls().isEmpty()) {
                    tooltips.add((FormattedText)Component.literal((String)data.rolls()));
                }
                if (!data.bonusRolls().isEmpty()) {
                    tooltips.add((FormattedText)Component.literal((String)data.bonusRolls()));
                }
            }
        }).setStandardSlotBackground();
    }
}

