/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.jei;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.capability.IFuelHandler;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.crafting.helper.Direction;
import es.degrassi.mmreborn.common.crafting.helper.FuelData;
import es.degrassi.mmreborn.common.crafting.helper.IDirectionalRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementFuel;
import es.degrassi.mmreborn.common.crafting.requirement.jei.JeiComponent;
import es.degrassi.mmreborn.common.integration.jei.MMRJeiPlugin;
import es.degrassi.mmreborn.common.integration.jei.category.MMRRecipeCategory;
import es.degrassi.mmreborn.common.integration.jei.category.drawable.FuelDrawable;
import es.degrassi.mmreborn.common.integration.jei.ingredient.CustomIngredientTypes;
import es.degrassi.mmreborn.common.machine.component.FuelComponent;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class JeiFuelComponent
extends JeiComponent<Long, RecipeRequirement<FuelComponent, RequirementFuel, IFuelHandler>>
implements IDirectionalRequirement {
    private final FuelDrawable progress;
    private final FuelData progressData;

    public JeiFuelComponent(RecipeRequirement<FuelComponent, RequirementFuel, IFuelHandler> requirement) {
        super(requirement, 0, 0);
        this.progressData = requirement.requirement().displayData();
        this.progress = new FuelDrawable(40, this.toJEIDirection(), this.progressData.getEmptyTexture(), this.progressData.getFillTexture());
    }

    @Override
    public ResourceLocation texture() {
        return ModularMachineryReborn.rl("textures/gui/widget/img.png");
    }

    @Override
    public Direction getDirection() {
        return this.progressData.direction();
    }

    @Override
    public int getWidth() {
        return this.progress.getWidth();
    }

    @Override
    public int getHeight() {
        return this.progress.getHeight();
    }

    @Override
    public List<Long> ingredients() {
        return Collections.singletonList(((RequirementFuel)this.requirement.requirement()).required);
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics, @NotNull Long ingredient) {
        this.progress.draw(guiGraphics, 0, 0);
    }

    @Override
    @NotNull
    public List<Component> getTooltip(@NotNull Long ingredient, @NotNull TooltipFlag tooltipFlag) {
        List<Component> tooltip = super.getTooltip(ingredient, tooltipFlag);
        tooltip.add((Component)Component.translatable((String)"modular_machinery_reborn.jei.ingredient.fuel", (Object[])new Object[]{Utils.format(((RequirementFuel)this.requirement.requirement()).required)}));
        return tooltip;
    }

    @Override
    public void setRecipe(MMRRecipeCategory category, IRecipeLayoutBuilder builder, MachineRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, this.getPosition().x(), this.getPosition().y()).setOverlay((IDrawable)MMRJeiPlugin.jeiHelpers.getGuiHelper().createBlankDrawable(this.getWidth(), this.getHeight()), 0, 0).setCustomRenderer(CustomIngredientTypes.LONG, (IIngredientRenderer)this).addIngredients(CustomIngredientTypes.LONG, this.ingredients());
    }

    private IDrawableAnimated.StartDirection toJEIDirection() {
        return switch (this.getDirection()) {
            default -> throw new MatchException(null, null);
            case Direction.LEFT -> IDrawableAnimated.StartDirection.LEFT;
            case Direction.RIGHT -> IDrawableAnimated.StartDirection.RIGHT;
            case Direction.TOP -> IDrawableAnimated.StartDirection.TOP;
            case Direction.BOTTOM -> IDrawableAnimated.StartDirection.BOTTOM;
        };
    }

    @Generated
    public FuelData getProgressData() {
        return this.progressData;
    }
}

