/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.jei;

import com.mojang.datafixers.util.Pair;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedSizedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementFluid;
import es.degrassi.mmreborn.common.crafting.requirement.jei.JeiComponent;
import es.degrassi.mmreborn.common.data.Config;
import es.degrassi.mmreborn.common.integration.jei.MMRJeiPlugin;
import es.degrassi.mmreborn.common.integration.jei.category.MMRRecipeCategory;
import es.degrassi.mmreborn.common.integration.jei.category.drawable.DrawableWrappedText;
import es.degrassi.mmreborn.common.machine.component.FluidComponent;
import es.degrassi.mmreborn.common.util.HybridTank;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class JeiFluidComponent
extends JeiComponent<FluidStack, RecipeRequirement<FluidComponent, RequirementFluid, HybridTank>> {
    public JeiFluidComponent(RecipeRequirement<FluidComponent, RequirementFluid, HybridTank> requirement) {
        super(requirement, 0, 0);
    }

    @Override
    public int getWidth() {
        return 16;
    }

    @Override
    public int getHeight() {
        return 16;
    }

    @Override
    public List<FluidStack> ingredients() {
        return Arrays.stream(((RequirementFluid)this.requirement.requirement()).getIngredient().getFluids()).toList();
    }

    @Override
    @NotNull
    public List<Component> getTooltip(@NotNull FluidStack ingredient, @NotNull TooltipFlag tooltipFlag) {
        List<Component> tooltip = super.getTooltip(ingredient, tooltipFlag);
        String mode = ((RequirementFluid)this.requirement.requirement()).getMode().isInput() ? "input" : "output";
        tooltip.add((Component)Component.translatable((String)("modular_machinery_reborn.jei.ingredient.fluid." + mode), (Object[])new Object[]{ingredient.getHoverName(), ingredient.getAmount()}));
        if (this.requirement.chance() < 1.0f && this.requirement.chance() >= 0.0f) {
            String keyNever = ((RequirementFluid)this.requirement.requirement()).getMode().isInput() ? "tooltip.machinery.chance.in.never" : "tooltip.machinery.chance.out.never";
            String keyChance = ((RequirementFluid)this.requirement.requirement()).getMode().isInput() ? "tooltip.machinery.chance.in" : "tooltip.machinery.chance.out";
            Object chanceStr = String.valueOf(Mth.floor((float)(this.requirement.chance() * 100.0f)));
            if (this.requirement.chance() == 0.0f) {
                tooltip.add((Component)Component.translatable((String)keyNever));
            } else {
                if (this.requirement.chance() < 0.01f) {
                    chanceStr = "< 1";
                }
                chanceStr = (String)chanceStr + "%";
                tooltip.add((Component)Component.translatable((String)keyChance, (Object[])new Object[]{chanceStr}));
            }
        }
        return tooltip;
    }

    @Override
    public void setRecipe(MMRRecipeCategory category, IRecipeLayoutBuilder builder, MachineRecipe recipe, IFocusGroup focuses) {
        int fluid = (int)(System.currentTimeMillis() / 1000L % (long)this.ingredients().size());
        MutableComponent component = Component.empty();
        String chance = Utils.decimalFormat(this.requirement.chance() * 100.0f);
        if (this.requirement.chance() > 0.0f && this.requirement.chance() < 1.0f) {
            component = Component.translatable((String)"modular_machinery_reborn.ingredient.chance", (Object[])new Object[]{chance, "%"}).withColor(Config.chanceColor);
        } else if (this.requirement.chance() == 0.0f) {
            component = Component.translatable((String)"modular_machinery_reborn.ingredient.chance.nc").withColor(Config.chanceColor);
        }
        Font font = Minecraft.getInstance().font;
        List<Pair<PositionedSizedRequirement, Object>> list = recipe.chanceTexts;
        PositionedSizedRequirement positionedSizedRequirement = new PositionedSizedRequirement(this.getPosition().x(), this.getPosition().y(), this.getWidth(), font.wordWrapHeight((FormattedText)component, this.getWidth()));
        DrawableWrappedText drawableWrappedText = new DrawableWrappedText(List.of(component), this.getWidth() + 2, true).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEX, this.getPosition().x()).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEY, this.getPosition().y()).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.SCALE, 0.75).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEZ, 500.0).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEX, (double)(this.getWidth() - 16) / 2.0).transform(DrawableWrappedText.Operation.ADD, DrawableWrappedText.State.TRANSLATEX, 17.0).transform(DrawableWrappedText.Operation.REMOVE, DrawableWrappedText.State.TRANSLATEX, Math.min(14, font.width((FormattedText)component))).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEY, (double)(this.getHeight() - 16) / 2.0).transform(DrawableWrappedText.Operation.REMOVE, DrawableWrappedText.State.TRANSLATEY, 1.0);
        Objects.requireNonNull(font);
        list.add((Pair<PositionedSizedRequirement, Object>)Pair.of((Object)positionedSizedRequirement, (Object)drawableWrappedText.transform(DrawableWrappedText.Operation.ADD, DrawableWrappedText.State.TRANSLATEY, 9.0 * 3.0 / 2.0)));
        builder.addSlot(this.role(), this.getPosition().x(), this.getPosition().y()).setOverlay((IDrawable)MMRJeiPlugin.jeiHelpers.getGuiHelper().createDrawable(this.texture(), this.getUOffset(), this.getVOffset(), this.getWidth() + 2, this.getHeight() + 2), -1, -1).setFluidRenderer((long)((RequirementFluid)((RecipeRequirement)this.getRequirement()).requirement()).getIngredient().amount(), false, this.getWidth(), this.getHeight()).addFluidStack(this.ingredients().get(fluid).getFluid(), (long)((RequirementFluid)((RecipeRequirement)this.getRequirement()).requirement()).getIngredient().amount()).addRichTooltipCallback((view, tooltip) -> {
            if (this.requirement.chance() > 0.0f && this.requirement.chance() < 1.0f) {
                tooltip.add((FormattedText)Component.translatable((String)("modular_machinery_reborn.ingredient.chance." + ((RequirementFluid)this.requirement.requirement()).getMode().name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{chance, "%"}));
            } else if (this.requirement.chance() == 0.0f) {
                tooltip.add((FormattedText)Component.translatable((String)"modular_machinery_reborn.ingredient.chance.not_consumed"));
            } else if (this.requirement.chance() == 1.0f) {
                tooltip.add((FormattedText)Component.translatable((String)("modular_machinery_reborn.jei.ingredient.item." + ((RequirementFluid)this.requirement.requirement()).getMode().name().toLowerCase(Locale.ROOT))));
            }
        });
    }
}

