/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.jei;

import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementEnergy;
import es.degrassi.mmreborn.common.crafting.requirement.jei.JeiComponent;
import es.degrassi.mmreborn.common.integration.jei.category.MMRRecipeCategory;
import es.degrassi.mmreborn.common.integration.jei.ingredient.CustomIngredientTypes;
import es.degrassi.mmreborn.common.machine.component.EnergyComponent;
import es.degrassi.mmreborn.common.util.IEnergyHandler;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class JeiEnergyComponent
extends JeiComponent<Long, RecipeRequirement<EnergyComponent, RequirementEnergy, IEnergyHandler>> {
    private int width = 16;
    private int height = 52;
    private int recipeTime;

    public JeiEnergyComponent(RecipeRequirement<EnergyComponent, RequirementEnergy, IEnergyHandler> requirement) {
        super(requirement, 18, 0);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public List<Long> ingredients() {
        return Collections.singletonList(((RequirementEnergy)this.requirement.requirement()).getRequiredEnergy());
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics, @NotNull Long ingredient) {
        this.width += 2;
        this.height += 2;
        super.render(guiGraphics, ingredient);
        this.width -= 2;
        this.height -= 2;
    }

    @Override
    @NotNull
    public List<Component> getTooltip(@NotNull Long ingredient, @NotNull TooltipFlag tooltipFlag) {
        List<Component> tooltip = super.getTooltip(ingredient, tooltipFlag);
        String mode = ((RequirementEnergy)this.requirement.requirement()).getMode().isInput() ? "input" : "output";
        tooltip.add((Component)Component.translatable((String)("modular_machinery_reborn.jei.ingredient.energy." + mode), (Object[])new Object[]{Utils.format(((RequirementEnergy)this.requirement.requirement()).requirement)}));
        return tooltip;
    }

    @Override
    public void setRecipe(MMRRecipeCategory category, IRecipeLayoutBuilder builder, MachineRecipe recipe, IFocusGroup focuses) {
        this.recipeTime = recipe.getRecipeTotalTickTime();
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, this.getPosition().x(), this.getPosition().y()).setCustomRenderer(CustomIngredientTypes.LONG, (IIngredientRenderer)this).addIngredients(CustomIngredientTypes.LONG, this.ingredients());
    }
}

