/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.jei;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedSizedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementDurability;
import es.degrassi.mmreborn.common.crafting.requirement.jei.JeiComponent;
import es.degrassi.mmreborn.common.data.Config;
import es.degrassi.mmreborn.common.integration.jei.category.MMRRecipeCategory;
import es.degrassi.mmreborn.common.integration.jei.category.drawable.DrawableWrappedText;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.DurabilityComponent;
import es.degrassi.mmreborn.common.util.IOInventory;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;

public class JeiDurabilityComponent
extends JeiComponent<ItemStack, RecipeRequirement<DurabilityComponent, RequirementDurability, IOInventory>> {
    private final List<ItemStack> items;

    public JeiDurabilityComponent(RecipeRequirement<DurabilityComponent, RequirementDurability, IOInventory> requirement) {
        super(requirement, 36, 0);
        this.items = ((Stream)Arrays.stream(requirement.requirement().getIngredient().getItems()).map(stack -> this.generateWithDurability((ItemStack)stack, ((RequirementDurability)requirement.requirement()).getAmount())).flatMap(Collection::stream).unordered()).toList();
    }

    @Override
    public int getWidth() {
        return 18;
    }

    @Override
    public int getHeight() {
        return 18;
    }

    @Override
    public List<ItemStack> ingredients() {
        return this.items;
    }

    private List<ItemStack> generateWithDurability(ItemStack stack, int amount) {
        if (!stack.isDamageableItem()) {
            throw new IllegalArgumentException("Invalid not damageable item in durability requirement");
        }
        int maxDamage = stack.getMaxDamage();
        ArrayList damagedItems = Lists.newArrayList();
        if (maxDamage <= 10) {
            for (int i = 0; i <= maxDamage; ++i) {
                ItemStack copy = stack.copyWithCount(amount);
                copy.setDamageValue(i);
                damagedItems.add(copy);
            }
        } else {
            for (int i = 0; i <= 10; ++i) {
                ItemStack copy = stack.copyWithCount(amount);
                copy.setDamageValue(Mth.randomBetweenInclusive((RandomSource)RandomSource.create(), (int)0, (int)maxDamage));
                damagedItems.add(copy);
            }
        }
        return ((Stream)damagedItems.stream().unordered()).toList();
    }

    @Override
    public void setRecipe(MMRRecipeCategory category, IRecipeLayoutBuilder builder, MachineRecipe recipe, IFocusGroup focuses) {
        MutableComponent component = Component.empty();
        String chance = Utils.decimalFormat(this.requirement.chance() * 100.0f);
        if (this.requirement.chance() > 0.0f && this.requirement.chance() < 1.0f) {
            component = Component.translatable((String)"modular_machinery_reborn.ingredient.chance", (Object[])new Object[]{chance, "%"}).withColor(Config.chanceColor);
        } else if (this.requirement.chance() == 0.0f) {
            component = Component.translatable((String)"modular_machinery_reborn.ingredient.chance.nc").withColor(Config.chanceColor);
        }
        Font font = Minecraft.getInstance().font;
        recipe.chanceTexts.add((Pair<PositionedSizedRequirement, Object>)Pair.of((Object)new PositionedSizedRequirement(this.getPosition().x(), this.getPosition().y(), this.getWidth(), font.wordWrapHeight((FormattedText)component, this.getWidth())), (Object)new DrawableWrappedText(List.of(component), this.getWidth() + 2, true).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEX, this.getPosition().x()).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEY, this.getPosition().y()).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.SCALE, 0.75).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEZ, 500.0).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEX, (double)(this.getWidth() - 16) / 2.0).transform(DrawableWrappedText.Operation.ADD, DrawableWrappedText.State.TRANSLATEX, 17.0).transform(DrawableWrappedText.Operation.REMOVE, DrawableWrappedText.State.TRANSLATEX, Math.min(14, font.width((FormattedText)component))).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEY, (double)(this.getHeight() - 16) / 2.0).transform(DrawableWrappedText.Operation.MULTIPLY, DrawableWrappedText.State.TRANSLATEY, -1.0).transform(DrawableWrappedText.Operation.REMOVE, DrawableWrappedText.State.TRANSLATEY, 2.0)));
        ((IRecipeSlotBuilder)builder.addSlot(this.role(), this.getPosition().x(), this.getPosition().y()).addItemStacks(this.ingredients())).addRichTooltipCallback((view, tooltip) -> {
            if (((RequirementDurability)this.requirement.requirement()).getMode().isInput()) {
                tooltip.add((FormattedText)Component.translatable((String)"modular_machinery_reborn.ingredient.durability.consume", (Object[])new Object[]{((RequirementDurability)this.requirement.requirement()).getAmount()}));
            } else if (((RequirementDurability)this.requirement.requirement()).getMode() == IOType.OUTPUT) {
                tooltip.add((FormattedText)Component.translatable((String)"modular_machinery_reborn.ingredient.durability.repair", (Object[])new Object[]{((RequirementDurability)this.requirement.requirement()).getAmount()}));
            }
            if (this.requirement.chance() > 0.0f && this.requirement.chance() < 1.0f) {
                tooltip.add((FormattedText)Component.translatable((String)("modular_machinery_reborn.ingredient.chance." + ((RequirementDurability)this.requirement.requirement()).getMode().name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{chance, "%"}));
            } else if (this.requirement.chance() == 0.0f) {
                tooltip.add((FormattedText)Component.translatable((String)"modular_machinery_reborn.ingredient.chance.not_consumed"));
            }
        }).setStandardSlotBackground();
    }
}

