/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.entity;

import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.capability.EntityHandler;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.codec.RegistrarCodec;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IDisplayInfo;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.crafting.requirement.entity.RequirementEntity;
import es.degrassi.mmreborn.common.machine.component.EntityComponent;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;

public class RequirementKillEntity
extends RequirementEntity {
    public static final NamedCodec<RequirementKillEntity> CODEC = NamedCodec.record(instance -> instance.group(NamedCodec.INT.fieldOf("amount").forGetter(RequirementEntity::getAmount), NamedCodec.INT.fieldOf("radius").forGetter(RequirementEntity::getRadius), RegistrarCodec.ENTITY.listOf().optionalFieldOf("entity", Collections.emptyList()).forGetter(RequirementKillEntity::getEntityTypes)).apply((Applicative)instance, RequirementKillEntity::new), "Kill Entity Requirement");
    private final List<EntityType<?>> entityTypes;

    public RequirementKillEntity(int amount, int radius, List<EntityType<?>> entityTypes) {
        super(RequirementEntity.Action.KILL, amount, radius);
        this.entityTypes = entityTypes;
    }

    @Override
    public RequirementType<RequirementKillEntity, EntityComponent, EntityHandler> getType() {
        return RequirementTypeRegistration.KILL_ENTITY.get();
    }

    @Override
    public boolean test(EntityComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.getAmount(), this);
        int radius = (int)context.getIntegerModifiedValue(this.getRadius(), this);
        return component.getContainerProvider().getEntitiesInRadius(radius, this::predicate) >= amount;
    }

    @Override
    public void gatherRequirements(IRequirementList<EntityComponent> list) {
        list.process(this.getMode(), this::process);
    }

    private CraftingResult process(EntityComponent component, ICraftingContext context) {
        if (component.getContainerProvider().getEntitiesInRadius(this.getRadius(), this::predicate) >= this.getAmount()) {
            component.getContainerProvider().killEntities(this.getRadius(), this::predicate, this.getAmount());
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.entity.amount"));
    }

    private boolean predicate(Entity entity) {
        return this.entityTypes.contains(entity.getType());
    }

    @Override
    public void getDefaultDisplayInfo(IDisplayInfo info, RecipeRequirement<?, ?, ?> requirement) {
        super.getDefaultDisplayInfo(info, requirement);
        if (!this.entityTypes.isEmpty()) {
            info.addTooltip((Component)Component.translatable((String)"modular_machinery_reborn.jei.ingredient.entity.whitelist"));
            this.entityTypes.forEach(type -> info.addTooltip((Component)Component.literal((String)"*").append(type.getDescription())));
        }
        info.setItemIcon(Items.MOOSHROOM_SPAWN_EGG);
    }

    @Generated
    public List<EntityType<?>> getEntityTypes() {
        return this.entityTypes;
    }
}

