/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.entity;

import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.capability.EntityHandler;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.codec.RegistrarCodec;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IDisplayInfo;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.crafting.requirement.entity.RequirementEntity;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.EntityComponent;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;

public class RequirementHealthEntity
extends RequirementEntity {
    public static final NamedCodec<RequirementHealthEntity> CODEC = NamedCodec.record(instance -> instance.group(NamedCodec.INT.fieldOf("amount").forGetter(RequirementEntity::getAmount), NamedCodec.INT.fieldOf("radius").forGetter(RequirementEntity::getRadius), Mode.CODEC.fieldOf("mode").forGetter(RequirementHealthEntity::getHealthMode), RegistrarCodec.ENTITY.listOf().optionalFieldOf("entity", Collections.emptyList()).forGetter(RequirementHealthEntity::getEntityTypes)).apply((Applicative)instance, RequirementHealthEntity::new), "Add or Remove Health Entity Requirement");
    private final List<EntityType<?>> entityTypes;
    private final Mode healthMode;

    public RequirementHealthEntity(int amount, int radius, Mode healthMode, List<EntityType<?>> entityTypes) {
        super(healthMode.toIOType(), healthMode.isInput() ? RequirementEntity.Action.CONSUME_HEALTH : RequirementEntity.Action.ADD_HEALTH, amount, radius);
        this.entityTypes = entityTypes;
        this.healthMode = healthMode;
    }

    @Override
    public RequirementType<RequirementHealthEntity, EntityComponent, EntityHandler> getType() {
        return RequirementTypeRegistration.HEATH_ENTITY.get();
    }

    @Override
    public boolean test(EntityComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.getAmount(), this);
        int radius = (int)context.getIntegerModifiedValue(this.getRadius(), this);
        return switch (this.healthMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> component.getContainerProvider().canHurtEntitiesInRadius(radius, this.getFilter(), amount);
            case 1 -> component.getContainerProvider().canHealEntitiesInRadius(radius, this.getFilter(), amount);
        };
    }

    private Predicate<Entity> getFilter() {
        return entity -> this.entityTypes.isEmpty() || this.entityTypes.contains(entity.getType());
    }

    @Override
    public void gatherRequirements(IRequirementList<EntityComponent> list) {
        switch (this.healthMode.ordinal()) {
            case 0: {
                list.processOnStart(this::process);
                break;
            }
            case 1: {
                list.processOnEnd(this::process);
            }
        }
    }

    public CraftingResult process(EntityComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.getAmount(), this);
        int radius = (int)context.getIntegerModifiedValue(this.getRadius(), this);
        switch (this.healthMode.ordinal()) {
            case 0: {
                component.getContainerProvider().removeEntitiesHealth(radius, this.getFilter(), amount);
                break;
            }
            case 1: {
                component.getContainerProvider().addEntitiesHealth(radius, this.getFilter(), amount);
            }
        }
        return CraftingResult.success();
    }

    @Override
    public void getDefaultDisplayInfo(IDisplayInfo info, RecipeRequirement<?, ?, ?> requirement) {
        super.getDefaultDisplayInfo(info, requirement);
        if (!this.entityTypes.isEmpty()) {
            info.addTooltip((Component)Component.translatable((String)"modular_machinery_reborn.jei.ingredient.entity.whitelist"));
            this.entityTypes.forEach(type -> info.addTooltip((Component)Component.literal((String)"*").append(type.getDescription())));
        }
        switch (this.healthMode.ordinal()) {
            case 0: {
                info.setItemIcon(Items.MOOSHROOM_SPAWN_EGG);
                break;
            }
            case 1: {
                info.setItemIcon(Items.SLIME_SPAWN_EGG);
            }
        }
    }

    @Generated
    public List<EntityType<?>> getEntityTypes() {
        return this.entityTypes;
    }

    @Generated
    public Mode getHealthMode() {
        return this.healthMode;
    }

    public static enum Mode {
        INPUT,
        OUTPUT;

        public static final NamedCodec<Mode> CODEC;

        public static Mode value(String mode) {
            return Mode.valueOf(mode.toUpperCase(Locale.ENGLISH));
        }

        public IOType toIOType() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> IOType.INPUT;
                case 1 -> IOType.OUTPUT;
            };
        }

        private boolean isInput() {
            return this == INPUT;
        }

        static {
            CODEC = NamedCodec.enumCodec(Mode.class);
        }
    }
}

