/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.entity;

import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.capability.EntityHandler;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.codec.RegistrarCodec;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IDisplayInfo;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.crafting.requirement.entity.RequirementEntity;
import es.degrassi.mmreborn.common.machine.component.EntityComponent;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;

public class RequirementCheckEntity
extends RequirementEntity {
    public static final NamedCodec<RequirementCheckEntity> CODEC = NamedCodec.record(instance -> instance.group(NamedCodec.INT.fieldOf("amount").forGetter(RequirementEntity::getAmount), NamedCodec.INT.fieldOf("radius").forGetter(RequirementEntity::getRadius), CheckAction.CODEC.fieldOf("check_type").forGetter(RequirementCheckEntity::getCheckActionMode), RegistrarCodec.ENTITY.listOf().optionalFieldOf("filter", Collections.emptyList()).forGetter(RequirementCheckEntity::getEntityTypes), NamedCodec.BOOL.optionalFieldOf("whitelist", false).forGetter(RequirementCheckEntity::isWhitelist)).apply((Applicative)instance, RequirementCheckEntity::new), "Check Entity Requirement");
    private final List<EntityType<?>> entityTypes;
    private final boolean whitelist;
    private final CheckAction checkActionMode;

    public RequirementCheckEntity(int amount, int radius, CheckAction mode, List<EntityType<?>> entityTypes, boolean whitelist) {
        super(mode.toAction(), amount, radius);
        this.entityTypes = entityTypes;
        this.checkActionMode = mode;
        this.whitelist = whitelist;
    }

    private boolean predicate(Entity entity) {
        return this.entityTypes.contains(entity.getType()) == this.whitelist;
    }

    @Override
    public RequirementType<RequirementCheckEntity, EntityComponent, EntityHandler> getType() {
        return RequirementTypeRegistration.CHECK_ENTITY.get();
    }

    @Override
    public boolean test(EntityComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.getAmount(), this);
        int radius = (int)context.getIntegerModifiedValue(this.getRadius(), this);
        return switch (this.getCheckActionMode().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (component.getContainerProvider().getEntitiesInRadiusHealth(radius, this::predicate) >= (double)amount) {
                    yield true;
                }
                yield false;
            }
            case 1 -> component.getContainerProvider().getEntitiesInRadius(radius, this::predicate) >= amount;
        };
    }

    @Override
    public void gatherRequirements(IRequirementList<EntityComponent> list) {
        list.processEachTick(this::check);
    }

    private CraftingResult check(EntityComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.getAmount(), this);
        int radius = (int)context.getIntegerModifiedValue(this.getRadius(), this);
        if (this.getAction() == RequirementEntity.Action.CHECK_AMOUNT) {
            return component.getContainerProvider().getEntitiesInRadius(radius, this::predicate) >= amount ? CraftingResult.success() : CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.entity.amount"));
        }
        if (this.getAction() == RequirementEntity.Action.CHECK_HEALTH) {
            return component.getContainerProvider().getEntitiesInRadiusHealth(radius, this::predicate) >= (double)amount ? CraftingResult.success() : CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.entity.health", (Object[])new Object[]{amount}));
        }
        return CraftingResult.pass();
    }

    @Override
    public void getDefaultDisplayInfo(IDisplayInfo info, RecipeRequirement<?, ?, ?> requirement) {
        super.getDefaultDisplayInfo(info, requirement);
        if (!this.entityTypes.isEmpty()) {
            info.addTooltip((Component)Component.translatable((String)("modular_machinery_reborn.jei.ingredient.entity." + (this.whitelist ? "whitelist" : "blacklist"))));
            this.entityTypes.forEach(type -> info.addTooltip((Component)Component.literal((String)"*").append(type.getDescription())));
        }
        info.setItemIcon(Items.TROPICAL_FISH_SPAWN_EGG);
    }

    @Generated
    public List<EntityType<?>> getEntityTypes() {
        return this.entityTypes;
    }

    @Generated
    public boolean isWhitelist() {
        return this.whitelist;
    }

    @Generated
    public CheckAction getCheckActionMode() {
        return this.checkActionMode;
    }

    public static enum CheckAction {
        HEALTH,
        AMOUNT;

        public static final NamedCodec<CheckAction> CODEC;

        public static CheckAction value(String value) {
            return CheckAction.valueOf(value.toUpperCase(Locale.ENGLISH));
        }

        public RequirementEntity.Action toAction() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> RequirementEntity.Action.CHECK_AMOUNT;
                case 0 -> RequirementEntity.Action.CHECK_HEALTH;
            };
        }

        static {
            CODEC = NamedCodec.enumCodec(CheckAction.class);
        }
    }
}

