/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.emi;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.screen.EmiScreenManager;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.client.requirement.ItemRendering;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementLootTable;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.SlotTooltip;
import es.degrassi.mmreborn.common.machine.component.ItemComponent;
import es.degrassi.mmreborn.common.util.IOInventory;
import es.degrassi.mmreborn.common.util.LootTableHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class EmiLootTableComponent
extends EmiComponent<ResourceLocation, RecipeRequirement<ItemComponent, RequirementLootTable, IOInventory>>
implements SlotTooltip,
ItemRendering {
    private int item;
    private int width = 16;
    private int height = 16;
    private EmiRecipe recipe;
    private final List<ItemStack> loots;

    public EmiLootTableComponent(RecipeRequirement<ItemComponent, RequirementLootTable, IOInventory> requirement) {
        super(requirement, 36, 0);
        List<LootTableHelper.LootData> loots = LootTableHelper.getLootsForTable(requirement.requirement().getLootTable());
        this.loots = Lists.newArrayList(loots.stream().map(LootTableHelper.LootData::stack).toList());
    }

    @Override
    public void recipeContext(EmiRecipe recipe) {
        this.recipe = recipe;
    }

    @Override
    public EmiStack getStack() {
        return EmiStack.of((ItemStack)this.loots().get(this.item));
    }

    @Override
    public List<ResourceLocation> ingredients() {
        return Collections.singletonList(((RequirementLootTable)this.requirement.requirement()).getLootTable());
    }

    private List<ItemStack> loots() {
        return this.loots;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.item = (int)(System.currentTimeMillis() / 1000L % (long)this.loots().size());
        this.width += 2;
        this.height += 2;
        super.render(guiGraphics, mouseX, mouseY);
        this.width -= 2;
        this.height -= 2;
        this.drawStack(guiGraphics, 1, 1, -1);
    }

    @Override
    public List<Component> getTooltip() {
        ArrayList list = Lists.newArrayList();
        List<LootTableHelper.LootData> loots = LootTableHelper.getLootsForTable(((RequirementLootTable)this.requirement.requirement()).getLootTable());
        LootTableHelper.LootData data = loots.stream().filter(lootData -> ItemStack.isSameItemSameComponents((ItemStack)lootData.stack(), (ItemStack)this.loots().get(this.item))).findFirst().orElse(null);
        if (data == null) {
            return list;
        }
        if (data.chance() != 1.0) {
            double percentage = data.chance() * 100.0;
            if (percentage < (double)0.01f) {
                list.add(Component.translatable((String)("modular_machinery_reborn.ingredient.chance." + ((RequirementLootTable)this.requirement.requirement()).getMode().name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{"<0.01", "%"}));
            } else {
                BigDecimal decimal = BigDecimal.valueOf(percentage).setScale(2, RoundingMode.HALF_UP);
                if (decimal.scale() <= 0 || decimal.signum() == 0 || decimal.stripTrailingZeros().scale() <= 0) {
                    list.add(Component.translatable((String)("modular_machinery_reborn.ingredient.chance." + ((RequirementLootTable)this.requirement.requirement()).getMode().name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{decimal.intValue(), "%"}));
                } else {
                    list.add(Component.translatable((String)("modular_machinery_reborn.ingredient.chance." + ((RequirementLootTable)this.requirement.requirement()).getMode().name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{decimal.doubleValue(), "%"}));
                }
            }
            if (!data.rolls().isEmpty()) {
                list.add(Component.literal((String)data.rolls()));
            }
            if (!data.bonusRolls().isEmpty()) {
                list.add(Component.literal((String)data.bonusRolls()));
            }
        }
        list.addAll(this.getStack().getTooltipText());
        return list;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.slotInteraction(bind -> bind.matchesMouse(button))) {
            return true;
        }
        return EmiScreenManager.stackInteraction((EmiStackInteraction)new EmiStackInteraction((EmiIngredient)this.getStack(), this.getRecipe(), true), bind -> bind.matchesMouse(button));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.slotInteraction(bind -> bind.matchesKey(keyCode, scanCode))) {
            return true;
        }
        return EmiScreenManager.stackInteraction((EmiStackInteraction)new EmiStackInteraction((EmiIngredient)this.getStack(), this.getRecipe(), true), bind -> bind.matchesKey(keyCode, scanCode));
    }

    @Override
    @Generated
    public int getWidth() {
        return this.width;
    }

    @Override
    @Generated
    public int getHeight() {
        return this.height;
    }

    @Override
    @Generated
    public EmiRecipe getRecipe() {
        return this.recipe;
    }
}

