/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.emi;

import dev.emi.emi.api.widget.AnimatedTextureWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import es.degrassi.mmreborn.api.capability.IFuelHandler;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.helper.Direction;
import es.degrassi.mmreborn.common.crafting.helper.FuelData;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementFuel;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiComponent;
import es.degrassi.mmreborn.common.integration.emi.recipe.MMREmiRecipe;
import es.degrassi.mmreborn.common.machine.component.FuelComponent;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class EmiFuelComponent
extends EmiComponent<Long, RecipeRequirement<FuelComponent, RequirementFuel, IFuelHandler>> {
    private final FuelData fuelData;
    private final AnimatedTextureWidget fuel;

    public EmiFuelComponent(RecipeRequirement<FuelComponent, RequirementFuel, IFuelHandler> requirement) {
        super(requirement, 0, 0, false);
        this.fuelData = requirement.requirement().displayData();
        this.fuel = this.createProgress();
    }

    @Override
    public int getWidth() {
        return this.fuel.getBounds().width();
    }

    @Override
    public int getHeight() {
        return this.fuel.getBounds().height();
    }

    @Override
    public List<Long> ingredients() {
        return Collections.singletonList(((RequirementFuel)this.requirement.requirement()).required);
    }

    @Override
    @Nullable
    public ResourceLocation texture() {
        return this.fuelData.getEmptyTexture();
    }

    public Direction getDirection() {
        return this.fuelData.direction();
    }

    private AnimatedTextureWidget createProgress() {
        return new AnimatedTextureWidget(this.fuelData.getFillTexture(), 1, 1, TextureSizeHelper.getWidth(this.fuelData.getFillTexture()), TextureSizeHelper.getHeight(this.fuelData.getFillTexture()), 0, 0, TextureSizeHelper.getWidth(this.fuelData.getFillTexture()), TextureSizeHelper.getHeight(this.fuelData.getFillTexture()), TextureSizeHelper.getWidth(this.fuelData.getFillTexture()), TextureSizeHelper.getHeight(this.fuelData.getFillTexture()), 2000, this.getDirection().horizontal(), this.getDirection().endToStart(), true);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.render(guiGraphics, mouseX, mouseY);
        this.fuel.render(guiGraphics, mouseX, mouseY, 0.0f);
    }

    @Override
    public List<Component> getTooltip() {
        LinkedList<Component> tooltip = new LinkedList<Component>();
        tooltip.add((Component)Component.translatable((String)"modular_machinery_reborn.jei.ingredient.fuel", (Object[])new Object[]{Utils.format(((RequirementFuel)this.requirement.requirement()).required)}));
        return tooltip;
    }

    @Override
    public void addWidgets(WidgetHolder widgets, MMREmiRecipe recipe) {
        super.addWidgets(widgets, recipe);
    }

    @Generated
    public FuelData getFuelData() {
        return this.fuelData;
    }

    @Generated
    public AnimatedTextureWidget getFuel() {
        return this.fuel;
    }
}

