/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.emi;

import dev.emi.emi.api.widget.AnimatedTextureWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.helper.Direction;
import es.degrassi.mmreborn.common.crafting.helper.IDirectionalRequirement;
import es.degrassi.mmreborn.common.crafting.helper.ProgressData;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementDuration;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiComponent;
import es.degrassi.mmreborn.common.integration.emi.recipe.MMREmiRecipe;
import es.degrassi.mmreborn.common.machine.component.DurationComponent;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class EmiDurationComponent
extends EmiComponent<Integer, RecipeRequirement<DurationComponent, RequirementDuration, Void>>
implements IDirectionalRequirement {
    private int duration;
    private final ProgressData progressData;
    private final int ticks;
    private final AnimatedTextureWidget progress;
    private final boolean inverted;

    public EmiDurationComponent(RecipeRequirement<DurationComponent, RequirementDuration, Void> requirement, int msPerCycle, ProgressData progressData, boolean inverted) {
        super(requirement, 0, 0, false);
        this.progressData = progressData;
        this.ticks = msPerCycle;
        this.progress = this.createProgress();
        this.inverted = inverted;
    }

    @Override
    @Nullable
    public ResourceLocation texture() {
        return this.progressData.getEmptyTexture();
    }

    @Override
    public Direction getDirection() {
        return this.progressData.direction();
    }

    private AnimatedTextureWidget createProgress() {
        return new AnimatedTextureWidget(this.progressData.getFillTexture(), 0, 0, TextureSizeHelper.getWidth(this.progressData.getFillTexture()), TextureSizeHelper.getHeight(this.progressData.getFillTexture()), 0, 0, TextureSizeHelper.getWidth(this.progressData.getFillTexture()), TextureSizeHelper.getHeight(this.progressData.getFillTexture()), TextureSizeHelper.getWidth(this.progressData.getFillTexture()), TextureSizeHelper.getHeight(this.progressData.getFillTexture()), this.ticks, this.getDirection().horizontal(), this.getDirection().endToStart(), this.inverted);
    }

    @Override
    public List<Integer> ingredients() {
        return List.of(Integer.valueOf(this.duration));
    }

    @Override
    public int getWidth() {
        return this.progress.getBounds().width();
    }

    @Override
    public int getHeight() {
        return this.progress.getBounds().height();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.render(guiGraphics, mouseX, mouseY);
        this.progress.render(guiGraphics, mouseX, mouseY, 0.0f);
    }

    @Override
    public List<Component> getTooltip() {
        List<Component> tooltip = super.getTooltip();
        tooltip.add((Component)Component.translatable((String)"modular_machinery_reborn.jei.ingredient.duration", (Object[])new Object[]{this.duration}));
        return tooltip;
    }

    @Override
    public void addWidgets(WidgetHolder widgets, MMREmiRecipe recipe) {
        this.duration = recipe.getRecipe().getRecipeTotalTickTime();
        super.addWidgets(widgets, recipe);
    }
}

