/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.emi;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.DrawableWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.runtime.EmiDrawContext;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.emi.IEmiRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.emi.RecipeHolder;
import es.degrassi.mmreborn.common.crafting.requirement.emi.SlotTooltip;
import es.degrassi.mmreborn.common.integration.emi.recipe.MMREmiRecipe;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class EmiComponent<X, R extends RecipeRequirement<?, ?, ?>>
extends DrawableWidget
implements IEmiRequirement<R> {
    protected static final ResourceLocation LOCATION_ICONS = ResourceLocation.fromNamespaceAndPath((String)"modular_machinery_reborn", (String)"textures/gui/jeirecipeicons.png");
    protected R requirement;
    protected final int uOffset;
    protected final int vOffset;
    private final boolean renderOverlay;

    protected EmiComponent(R requirement, int uOffset, int vOffset) {
        this(requirement, uOffset, vOffset, true);
    }

    protected EmiComponent(R requirement, int uOffset, int vOffset, boolean renderOverlay) {
        super(((RecipeRequirement)requirement).requirement().getPosition().x(), ((RecipeRequirement)requirement).requirement().getPosition().y(), 0, 0, null);
        this.requirement = requirement;
        this.uOffset = uOffset;
        this.vOffset = vOffset;
        this.renderOverlay = renderOverlay;
    }

    public Bounds getBounds() {
        return new Bounds(this.x, this.y, this.getWidth(), this.getHeight());
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    @Nullable
    public ResourceLocation texture() {
        return LOCATION_ICONS;
    }

    public final void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap((GuiGraphics)guiGraphics);
        context.push();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        context.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        context.matrices().translate((float)this.x, (float)this.y, 0.0f);
        this.render(guiGraphics, mouseX, mouseY);
        context.pop();
        this.renderOverlay(guiGraphics, mouseX, mouseY);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ResourceLocation texture = this.texture();
        if (texture != null) {
            guiGraphics.blit(texture, 0, 0, 0, (float)this.uOffset, (float)this.vOffset, this.getWidth(), this.getHeight(), TextureSizeHelper.getWidth(this.texture()), TextureSizeHelper.getHeight(this.texture()));
        }
    }

    public final void renderOverlay(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.shouldDrawSlotHighlight(mouseX, mouseY)) {
            this.drawSlotHighlight(guiGraphics);
        }
    }

    public final boolean shouldDrawSlotHighlight(int mouseX, int mouseY) {
        return this.renderOverlay && mouseX >= this.x && mouseX < this.x + this.getWidth() && mouseY >= this.y && mouseY < this.y + this.getHeight();
    }

    public int getXHighlight() {
        return 1;
    }

    public int getYHighlight() {
        return 1;
    }

    public final void drawSlotHighlight(GuiGraphics guiGraphics) {
        EmiDrawContext context = EmiDrawContext.wrap((GuiGraphics)guiGraphics);
        context.push();
        context.matrices().translate((float)this.x, (float)this.y, 200.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        context.fill(this.getXHighlight(), this.getYHighlight(), this.getWidth(), this.getHeight(), -2130706433);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
        context.pop();
    }

    public final List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
        LinkedList<ClientTooltipComponent> list = new LinkedList<ClientTooltipComponent>(this.getTooltip().stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).toList());
        EmiComponent emiComponent = this;
        if (emiComponent instanceof SlotTooltip) {
            SlotTooltip tooltip = (SlotTooltip)((Object)emiComponent);
            tooltip.addSlotTooltip(list);
        }
        return list;
    }

    public List<Component> getTooltip() {
        return new LinkedList<Component>();
    }

    public abstract List<X> ingredients();

    @Override
    public void addWidgets(WidgetHolder widgets, MMREmiRecipe recipe) {
        EmiComponent emiComponent = this;
        if (emiComponent instanceof RecipeHolder) {
            RecipeHolder holder = (RecipeHolder)((Object)emiComponent);
            if (!((RecipeRequirement)this.requirement).requirement().getMode().isInput()) {
                holder.recipeContext((EmiRecipe)recipe);
            }
        }
        widgets.addTooltip(this::getTooltip, this.x, this.y, this.getWidth(), this.getHeight());
        widgets.add((Widget)this);
    }

    @Override
    @Generated
    public R getRequirement() {
        return this.requirement;
    }

    @Generated
    public int getUOffset() {
        return this.uOffset;
    }

    @Generated
    public int getVOffset() {
        return this.vOffset;
    }

    @Generated
    public boolean isRenderOverlay() {
        return this.renderOverlay;
    }
}

