/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.BlockIngredient;
import es.degrassi.mmreborn.api.Structure;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IDisplayInfo;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.client.entity.renderer.StructureCheckerRenderer;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.StructureComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class RequirementStructure
implements IRequirement<StructureComponent, Structure> {
    public static final NamedCodec<RequirementStructure> CODEC = NamedCodec.record(instance -> instance.group(Structure.CODEC.fieldOf("structure").forGetter(RequirementStructure::getStructure), NamedCodec.enumCodec(Action.class).optionalFieldOf("action", Action.CHECK).forGetter(RequirementStructure::getAction)).apply((Applicative)instance, RequirementStructure::new), "Requirement Structure");
    private final Structure structure;
    private final Action action;

    public RequirementStructure(Structure structure, Action action) {
        this.structure = structure;
        this.action = action;
    }

    @Override
    public RequirementType<RequirementStructure, StructureComponent, Structure> getType() {
        return RequirementTypeRegistration.STRUCTURE.get();
    }

    @Override
    public ComponentType<Structure> getComponentType() {
        return ComponentRegistration.COMPONENT_STRUCTURE.get();
    }

    @Override
    public IOType getMode() {
        return IOType.INPUT;
    }

    @Override
    public boolean test(StructureComponent component, ICraftingContext context) {
        return switch (this.action.ordinal()) {
            case 0, 1, 2 -> component.checkStructure(this.structure);
            default -> true;
        };
    }

    @Override
    public void gatherRequirements(IRequirementList<StructureComponent> list) {
        if (this.action == Action.CHECK) {
            list.worldCondition(this::check);
        } else {
            list.processDelayed(1.0, this::process);
        }
    }

    public CraftingResult process(StructureComponent component, ICraftingContext context) {
        switch (this.action.ordinal()) {
            case 2: {
                component.destroyStructure(this.structure, true);
                break;
            }
            case 1: {
                component.destroyStructure(this.structure, false);
                break;
            }
            case 3: {
                component.placeStructure(this.structure, true);
                break;
            }
            case 4: {
                component.placeStructure(this.structure, false);
            }
        }
        return CraftingResult.success();
    }

    public CraftingResult check(StructureComponent component, ICraftingContext context) {
        if (component.checkStructure(this.structure)) {
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.structure"));
    }

    @Override
    public PositionedRequirement getPosition() {
        return new PositionedRequirement(0, 0);
    }

    @Override
    public Component getMissingComponentErrorMessage(IOType ioType) {
        return Component.translatable((String)"component.missing.structure");
    }

    @Override
    public boolean isComponentValid(StructureComponent m, ICraftingContext context) {
        return true;
    }

    @Override
    public void getDefaultDisplayInfo(IDisplayInfo info, RecipeRequirement<?, ?, ?> requirement) {
        info.addTooltip((Component)Component.translatable((String)"modular_machinery_reborn.jei.ingredient.structure.info"));
        info.addTooltip((Component)Component.translatable((String)"modular_machinery_reborn.jei.ingredient.structure.click"));
        this.structure.getPattern().asList().stream().flatMap(Collection::stream).flatMap(s -> s.chars().mapToObj(c -> Character.valueOf((char)c))).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).forEach((key, amount) -> {
            BlockIngredient ingredients = this.structure.getPattern().asMap().get(key);
            if (ingredients != null && amount > 0L) {
                MutableComponent block = Component.translatable((String)"modular_machinery_reborn.jei.ingredient.structure.list", (Object[])new Object[]{amount, ingredients.getNamesUnified().withStyle(ChatFormatting.GOLD)});
                info.addTooltip((Component)Component.literal((String)"\u2713").withStyle(ChatFormatting.GREEN).append((Component)block), (player, advancedTooltips) -> this.hasBlockItem(player, ingredients, (long)amount));
                info.addTooltip((Component)Component.literal((String)"  ").append((Component)block), (player, advancedTooltips) -> !this.hasBlockItem(player, ingredients, (long)amount));
            }
        });
        switch (this.action.ordinal()) {
            case 2: {
                info.addTooltip((Component)Component.translatable((String)"modular_machinery_reborn.jei.ingredient.structure.break").withStyle(ChatFormatting.DARK_RED));
                break;
            }
            case 1: {
                info.addTooltip((Component)Component.translatable((String)"modular_machinery_reborn.jei.ingredient.structure.destroy").withStyle(ChatFormatting.DARK_RED));
                break;
            }
            case 3: 
            case 4: {
                info.addTooltip((Component)Component.translatable((String)"modular_machinery_reborn.jei.ingredient.structure.place").withStyle(ChatFormatting.DARK_RED));
            }
        }
        info.setClickAction((machine, recipe, mouseButton) -> StructureCheckerRenderer.add(machine.getRegistryName(), this.structure));
        info.setItemIcon(Items.STRUCTURE_BLOCK);
    }

    private boolean hasBlockItem(Player player, BlockIngredient block, long amount) {
        return player.getInventory().items.stream().filter(stack -> stack.getItem() instanceof BlockItem && block.test(((BlockItem)stack.getItem()).getBlock())).mapToLong(ItemStack::getCount).sum() >= amount;
    }

    @Override
    public JsonObject asJson() {
        JsonObject json = IRequirement.super.asJson();
        json.add("structure", (JsonElement)this.structure.asJson());
        json.addProperty("action", this.action.name().toLowerCase());
        return json;
    }

    @Generated
    public Structure getStructure() {
        return this.structure;
    }

    @Generated
    public Action getAction() {
        return this.action;
    }

    public static enum Action {
        CHECK,
        DESTROY,
        BREAK,
        PLACE_BREAK,
        PLACE_DESTROY;

    }
}

