/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import es.degrassi.mmreborn.api.codec.DefaultCodecs;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.integration.almostunified.AlmostUnifiedAdapter;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.ItemComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import es.degrassi.mmreborn.common.util.IOInventory;
import es.degrassi.mmreborn.common.util.Mods;
import java.util.Arrays;
import lombok.Generated;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public class RequirementItem
implements IRequirement<ItemComponent, IOInventory> {
    public static final NamedCodec<RequirementItem> CODEC = NamedCodec.record(instance -> instance.group(DefaultCodecs.SIZED_INGREDIENT_WITH_NBT.fieldOf("sizedIngredient").forGetter(req -> req.ingredient), NamedCodec.enumCodec(IOType.class).fieldOf("mode").forGetter(IRequirement::getMode), PositionedRequirement.POSITION_CODEC.optionalFieldOf("position", new PositionedRequirement(0, 0)).forGetter(IRequirement::getPosition), NamedCodec.BOOL.optionalFieldOf("modifiedByAU", false).forGetter(RequirementItem::isModified), NamedCodec.BOOL.optionalFieldOf("usesDataComponents", false).forGetter(RequirementItem::isUsesDataComponents)).apply((Applicative)instance, (item, mode, position, modified, usesDataComponents) -> {
        RequirementItem requirement = new RequirementItem((IOType)mode, (SizedIngredient)item, (PositionedRequirement)position);
        requirement.setModified(modified != false || requirement.modified);
        requirement.setUsesDataComponents(usesDataComponents != false || requirement.usesDataComponents);
        return requirement;
    }), "RequirementItem");
    public final SizedIngredient ingredient;
    private final IOType mode;
    private final PositionedRequirement position;
    private boolean modified = false;
    private boolean usesDataComponents;

    public RequirementItem(IOType ioType, SizedIngredient ingredient, PositionedRequirement position) {
        if (Mods.isAULoaded() && !ingredient.ingredient().isCustom()) {
            ingredient = new SizedIngredient(Ingredient.fromValues(Arrays.stream(ingredient.ingredient().getValues()).map(v -> {
                TagKey tag;
                if (v instanceof Ingredient.ItemValue) {
                    Item i;
                    ItemStack patt1$temp;
                    Ingredient.ItemValue $b$0 = (Ingredient.ItemValue)v;
                    ItemStack item = patt1$temp = $b$0.item();
                    if (!((Ingredient.ItemValue)v).item().getComponents().isEmpty() || (i = AlmostUnifiedAdapter.getPreferredItemForItem((Holder<Item>)item.getItemHolder())) == null) return v;
                    this.modified = true;
                    return new Ingredient.ItemValue(i.getDefaultInstance());
                }
                if (!(v instanceof Ingredient.TagValue)) return v;
                Ingredient.TagValue $b$2 = (Ingredient.TagValue)v;
                try {
                    TagKey patt3$temp;
                    tag = patt3$temp = $b$2.tag();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Item i = AlmostUnifiedAdapter.getPreferredItemForTag((TagKey<Item>)tag);
                if (i == null) return v;
                this.modified = true;
                return new Ingredient.ItemValue(i.getDefaultInstance());
            })), ingredient.count());
        }
        this.ingredient = ingredient;
        this.usesDataComponents = Arrays.stream(ingredient.ingredient().getItems()).anyMatch(stack -> !stack.getComponents().isEmpty());
        this.mode = ioType;
        this.position = position;
    }

    public JsonObject asJson(SizedIngredient ingredient) {
        JsonObject json = new JsonObject();
        JsonArray stacks = new JsonArray();
        for (ItemStack stack : ingredient.getItems()) {
            ItemStack.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)stack).result().map(JsonElement::toString).ifPresent(arg_0 -> ((JsonArray)stacks).add(arg_0));
        }
        json.add("items", (JsonElement)stacks);
        json.addProperty("count", (Number)ingredient.count());
        return json;
    }

    @Override
    public RequirementType<RequirementItem, ItemComponent, IOInventory> getType() {
        return RequirementTypeRegistration.ITEM.get();
    }

    @Override
    public ComponentType<IOInventory> getComponentType() {
        return ComponentRegistration.COMPONENT_ITEM.get();
    }

    @Override
    public boolean test(ItemComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.ingredient.count(), this);
        if (this.getMode() == IOType.INPUT) {
            return Arrays.stream(this.ingredient.getItems()).mapToInt(component::getItemAmount).sum() >= amount;
        }
        if (this.getMode() == IOType.OUTPUT) {
            if (this.ingredient.getItems().length > 0) {
                return component.getSpaceForItem(this.ingredient.getItems()[0]) >= amount;
            }
            throw new IllegalStateException("Can't use output empty item");
        }
        return true;
    }

    @Override
    public void gatherRequirements(IRequirementList<ItemComponent> list) {
        if (this.mode == IOType.INPUT) {
            list.processOnStart(this::processInput);
        } else {
            list.processOnEnd(this::processOutput);
        }
    }

    private CraftingResult processInput(ItemComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.ingredient.count(), this);
        int maxExtract = component.getIngredientAmount(this.ingredient.ingredient());
        if (maxExtract >= amount) {
            component.removeFromInputs(this.ingredient.ingredient(), amount);
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.item.input", (Object[])new Object[]{amount, this.ingredient.ingredient().toString()}));
    }

    private CraftingResult processOutput(ItemComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.ingredient.count(), this);
        if (this.ingredient.getItems().length > 0) {
            ItemStack item = this.ingredient.getItems()[0];
            int canInsert = component.getSpaceForItem(item);
            if (canInsert >= amount) {
                component.addToOutputs(item.copy(), amount);
                return CraftingResult.success();
            }
            return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.item.output.space"));
        }
        throw new IllegalStateException("Can't use output item requirement with item tag");
    }

    @Override
    public JsonObject asJson() {
        JsonObject json = IRequirement.super.asJson();
        json.add("ingredient", (JsonElement)this.asJson(this.ingredient));
        return json;
    }

    @Override
    @NotNull
    public Component getMissingComponentErrorMessage(IOType ioType) {
        return Component.translatable((String)String.format("component.missing.item.%s", ioType.name().toLowerCase()));
    }

    @Override
    public boolean isComponentValid(ItemComponent m, ICraftingContext context) {
        return this.getMode().equals(m.getIOType());
    }

    @Generated
    public SizedIngredient getIngredient() {
        return this.ingredient;
    }

    @Override
    @Generated
    public IOType getMode() {
        return this.mode;
    }

    @Override
    @Generated
    public PositionedRequirement getPosition() {
        return this.position;
    }

    @Override
    @Generated
    public boolean isModified() {
        return this.modified;
    }

    @Generated
    public boolean isUsesDataComponents() {
        return this.usesDataComponents;
    }

    @Override
    @Generated
    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Generated
    public void setUsesDataComponents(boolean usesDataComponents) {
        this.usesDataComponents = usesDataComponents;
    }
}

