/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.codec.NamedMapCodec;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.FluidComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import es.degrassi.mmreborn.common.util.HybridTank;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;

public class RequirementFluidPerTick
implements IRequirement<FluidComponent, HybridTank> {
    public static final NamedMapCodec<RequirementFluidPerTick> CODEC = NamedCodec.record(instance -> instance.group(NamedCodec.of(SizedFluidIngredient.FLAT_CODEC).fieldOf("fluid").forGetter(req -> req.ingredient), NamedCodec.enumCodec(IOType.class).fieldOf("mode").forGetter(IRequirement::getMode), PositionedRequirement.POSITION_CODEC.optionalFieldOf("position", new PositionedRequirement(0, 0)).forGetter(IRequirement::getPosition)).apply((Applicative)instance, (fluid, mode, position) -> new RequirementFluidPerTick((IOType)mode, (SizedFluidIngredient)fluid, (PositionedRequirement)position)), "FluidRequirement");
    private final PositionedRequirement position;
    private final IOType mode;
    private final SizedFluidIngredient ingredient;

    public RequirementFluidPerTick(IOType ioType, SizedFluidIngredient fluid, PositionedRequirement position) {
        this.ingredient = fluid;
        this.position = position;
        this.mode = ioType;
    }

    @Override
    public RequirementType<RequirementFluidPerTick, FluidComponent, HybridTank> getType() {
        return RequirementTypeRegistration.FLUID_PER_TICK.get();
    }

    @Override
    public ComponentType<HybridTank> getComponentType() {
        return ComponentRegistration.COMPONENT_FLUID.get();
    }

    @Override
    public boolean test(FluidComponent component, ICraftingContext context) {
        HybridTank handler = component.getContainerProvider();
        return switch (this.getMode()) {
            default -> throw new MatchException(null, null);
            case IOType.INPUT -> {
                int amount = (int)context.getPerTickIntegerModifiedValue(this.ingredient.amount(), this);
                if (this.ingredient.test(handler.getFluid()) && amount <= handler.getFluidAmount()) {
                    yield true;
                }
                yield false;
            }
            case IOType.OUTPUT -> {
                int amount = (int)context.getPerTickIntegerModifiedValue(this.ingredient.amount(), this);
                if ((handler.isEmpty() || this.ingredient.test(handler.getFluid())) && amount <= handler.getSpace()) {
                    yield true;
                }
                yield false;
            }
            case IOType.NONE -> true;
        };
    }

    @Override
    public void gatherRequirements(IRequirementList<FluidComponent> list) {
        switch (this.getMode()) {
            case INPUT: {
                list.processEachTick(this::processInput);
                break;
            }
            case OUTPUT: {
                list.processEachTick(this::processOutput);
            }
        }
    }

    private CraftingResult processInput(FluidComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.ingredient.amount(), this);
        int maxExtract = component.getContainerProvider().getFluidAmount();
        if (maxExtract >= amount) {
            component.removeFromInputs(this.ingredient.ingredient(), amount);
            return CraftingResult.success();
        }
        return this.errorInput(amount, component.getContainerProvider().getFluid(), component.getContainerProvider().getFluidAmount());
    }

    private CraftingResult errorInput(int amount, FluidStack found, int amountFound) {
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.fluid.input", (Object[])new Object[]{amount, this.ingredient.toString(), amountFound, found.getHoverName()}));
    }

    private CraftingResult errorOutput(FluidStack found) {
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.fluid.output.fluid", (Object[])new Object[]{this.ingredient.toString(), found.getHoverName()}));
    }

    private CraftingResult errorOutput(int amount, int requiredSpace) {
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.fluid.output.space", (Object[])new Object[]{requiredSpace, amount}));
    }

    private CraftingResult processOutput(FluidComponent component, ICraftingContext context) {
        HybridTank handler = component.getContainerProvider();
        FluidStack output = this.ingredient.getFluids()[0];
        if (!handler.isEmpty() && !this.ingredient.test(handler.getFluid())) {
            return this.errorOutput(handler.getFluid());
        }
        int amount = (int)context.getIntegerModifiedValue(this.ingredient.amount(), this);
        int canFill = handler.getSpace();
        if (canFill >= amount) {
            component.addToOutputs(output.copyWithAmount(amount));
            return CraftingResult.success();
        }
        return this.errorOutput(canFill, amount);
    }

    @Override
    public JsonObject asJson() {
        JsonObject json = IRequirement.super.asJson();
        json.addProperty("fluid", this.ingredient.toString());
        json.addProperty("amount", (Number)this.ingredient.amount());
        return json;
    }

    @Override
    @NotNull
    public Component getMissingComponentErrorMessage(IOType ioType) {
        return Component.translatable((String)String.format("component.missing.fluid.%s", ioType.name().toLowerCase()));
    }

    @Override
    public boolean isComponentValid(FluidComponent m, ICraftingContext context) {
        if (this.getMode().isInput()) {
            if (m.getContainerProvider().isEmpty()) {
                return false;
            }
        } else if (m.getContainerProvider().isEmpty()) {
            return true;
        }
        return this.ingredient.test(m.getContainerProvider().getFluid());
    }

    @Override
    @Generated
    public PositionedRequirement getPosition() {
        return this.position;
    }

    @Override
    @Generated
    public IOType getMode() {
        return this.mode;
    }

    @Generated
    public SizedFluidIngredient getIngredient() {
        return this.ingredient;
    }
}

