/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.experiencelib.api.capability.IExperienceHandler;
import es.degrassi.experiencelib.util.ExperienceUtils;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.codec.NamedMapCodec;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IDisplayInfo;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.ExperienceComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class RequirementExperience
implements IRequirement<ExperienceComponent, IExperienceHandler> {
    public static final NamedMapCodec<RequirementExperience> CODEC = NamedCodec.record(instance -> instance.group(NamedCodec.longRange(0L, Long.MAX_VALUE).fieldOf("amount").forGetter(req -> req.required), NamedCodec.enumCodec(IOType.class).fieldOf("mode").forGetter(IRequirement::getMode)).apply((Applicative)instance, (amount, type) -> new RequirementExperience((IOType)type, (long)amount)), "ExperienceRequirement");
    private final IOType mode;
    private final PositionedRequirement position;
    public final long required;

    public RequirementExperience(IOType actionType, long amount) {
        this.required = amount;
        this.position = new PositionedRequirement(0, 0);
        this.mode = actionType;
    }

    @Override
    public RequirementType<RequirementExperience, ExperienceComponent, IExperienceHandler> getType() {
        return RequirementTypeRegistration.EXPERIENCE.get();
    }

    @Override
    public ComponentType<IExperienceHandler> getComponentType() {
        return ComponentRegistration.COMPONENT_EXPERIENCE.get();
    }

    @Override
    public boolean test(ExperienceComponent component, ICraftingContext context) {
        IExperienceHandler handler = component.getContainerProvider();
        return switch (this.mode) {
            default -> throw new MatchException(null, null);
            case IOType.INPUT -> {
                if (handler.getExperience() >= this.required) {
                    yield true;
                }
                yield false;
            }
            case IOType.OUTPUT -> {
                if (handler.getExperienceCapacity() >= handler.getExperience() + this.required) {
                    yield true;
                }
                yield false;
            }
            case IOType.NONE -> true;
        };
    }

    @Override
    public void gatherRequirements(IRequirementList<ExperienceComponent> list) {
        if (this.mode.isInput()) {
            list.processOnStart(this::processInput);
        } else if (this.mode.isOutput()) {
            list.processOnEnd(this::processOutput);
        }
    }

    private CraftingResult processInput(ExperienceComponent component, ICraftingContext context) {
        int i;
        long toExtract;
        long amount;
        long originAmount = amount = (long)context.getModifiedValue(this.required, this);
        long canExtract = 0L;
        for (i = 0; i < component.getContainerProvider().getTanks() && amount > 0L; amount -= toExtract, ++i) {
            toExtract = component.getContainerProvider().extractExperienceRecipe(i, amount, true);
            canExtract += toExtract;
        }
        if (canExtract == originAmount) {
            for (i = 0; i < component.getContainerProvider().getTanks(); ++i) {
                toExtract = component.getContainerProvider().extractExperienceRecipe(i, canExtract, false);
                canExtract += toExtract;
            }
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.experience.input", (Object[])new Object[]{this.required, component.getContainerProvider().getExperience()}));
    }

    private CraftingResult processOutput(ExperienceComponent component, ICraftingContext context) {
        IExperienceHandler handler = component.getContainerProvider();
        long amount = (long)context.getModifiedValue(this.required, this);
        long remaining = handler.getExperienceCapacity() - handler.getExperience();
        if (remaining >= amount) {
            for (int i = 0; i < component.getContainerProvider().getTanks(); ++i) {
                amount -= component.getContainerProvider().receiveExperienceRecipe(i, amount, false);
            }
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.experience.output", (Object[])new Object[]{this.required, component.getContainerProvider().getExperienceCapacity() - component.getContainerProvider().getExperience()}));
    }

    @Override
    public JsonObject asJson() {
        JsonObject json = IRequirement.super.asJson();
        json.addProperty("amount", (Number)this.required);
        return json;
    }

    @Override
    @NotNull
    public Component getMissingComponentErrorMessage(IOType ioType) {
        return Component.translatable((String)String.format("component.missing.experience.%s", ioType.name().toLowerCase()));
    }

    @Override
    public boolean isComponentValid(ExperienceComponent m, ICraftingContext context) {
        return this.getMode().equals(m.getIOType());
    }

    @Override
    public void getDefaultDisplayInfo(IDisplayInfo info, RecipeRequirement<?, ?, ?> requirement) {
        String literal = String.format("%s XP", ExperienceUtils.format((long)this.getRequired()));
        String level = ExperienceUtils.format((long)ExperienceUtils.getLevelFromXp((long)this.getRequired()));
        info.addTooltip((Component)Component.translatable((String)("mmr.gui.element.experience.tooltip." + this.getMode().getSerializedName()), (Object[])new Object[]{literal, Component.translatable((String)"mmr.gui.element.experience.level", (Object[])new Object[]{level})}));
        info.setItemIcon(Items.EXPERIENCE_BOTTLE);
    }

    @Override
    @Generated
    public IOType getMode() {
        return this.mode;
    }

    @Override
    @Generated
    public PositionedRequirement getPosition() {
        return this.position;
    }

    @Generated
    public long getRequired() {
        return this.required;
    }
}

