/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.codec.NamedMapCodec;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.EnergyComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import es.degrassi.mmreborn.common.util.IEnergyHandler;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class RequirementEnergy
implements IRequirement<EnergyComponent, IEnergyHandler> {
    public static final NamedMapCodec<RequirementEnergy> CODEC = NamedCodec.record(instance -> instance.group(NamedCodec.longRange(0L, Long.MAX_VALUE).fieldOf("amount").forGetter(req -> req.requirement), NamedCodec.enumCodec(IOType.class).fieldOf("mode").forGetter(IRequirement::getMode), PositionedRequirement.POSITION_CODEC.optionalFieldOf("position", new PositionedRequirement(0, 0)).forGetter(IRequirement::getPosition)).apply((Applicative)instance, (amount, type, position) -> new RequirementEnergy((IOType)type, (long)amount, (PositionedRequirement)position)), "EnergyRequirement");
    private final IOType mode;
    private final PositionedRequirement position;
    public final long requirement;

    public RequirementEnergy(IOType ioType, long requirement, PositionedRequirement position) {
        this.requirement = requirement;
        this.position = position;
        this.mode = ioType;
    }

    public long getRequiredEnergy() {
        return this.requirement;
    }

    @Override
    public RequirementType<RequirementEnergy, EnergyComponent, IEnergyHandler> getType() {
        return RequirementTypeRegistration.ENERGY.get();
    }

    @Override
    public ComponentType<IEnergyHandler> getComponentType() {
        return ComponentRegistration.COMPONENT_ENERGY.get();
    }

    @Override
    public boolean test(EnergyComponent component, ICraftingContext context) {
        IEnergyHandler handler = component.getContainerProvider();
        return switch (this.mode) {
            default -> throw new MatchException(null, null);
            case IOType.INPUT -> {
                handler.setCanExtract(true);
                int extracted = handler.extractEnergy((int)this.requirement, true);
                component.getContainerProvider().setCanExtract(false);
                if ((long)extracted >= this.requirement) {
                    yield true;
                }
                yield false;
            }
            case IOType.OUTPUT -> {
                handler.setCanInsert(true);
                int received = handler.receiveEnergy((int)this.requirement, true);
                handler.setCanInsert(false);
                if ((long)received >= this.requirement) {
                    yield true;
                }
                yield false;
            }
            case IOType.NONE -> false;
        };
    }

    @Override
    public void gatherRequirements(IRequirementList<EnergyComponent> list) {
        if (this.mode.isInput()) {
            list.processOnStart(this::processInputs);
        } else {
            list.processOnEnd(this::processOutputs);
        }
    }

    private CraftingResult processInputs(EnergyComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.requirement, this);
        component.getContainerProvider().setCanExtract(true);
        int canExtract = component.getContainerProvider().extractEnergy(amount, true);
        if (canExtract >= amount) {
            component.getContainerProvider().extractEnergy(amount, false);
            component.getContainerProvider().setCanExtract(false);
            return CraftingResult.success();
        }
        component.getContainerProvider().setCanExtract(false);
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.energy.input", (Object[])new Object[]{this.requirement, component.getContainerProvider().getCurrentEnergy()}));
    }

    private CraftingResult processOutputs(EnergyComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.requirement, this);
        component.getContainerProvider().setCanInsert(true);
        int canReceive = component.getContainerProvider().receiveEnergy(amount, true);
        if (canReceive >= amount) {
            component.getContainerProvider().receiveEnergy(amount, false);
            component.getContainerProvider().setCanInsert(false);
            return CraftingResult.success();
        }
        component.getContainerProvider().setCanInsert(false);
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.energy.output", (Object[])new Object[]{this.requirement, component.getContainerProvider().getRemainingCapacity()}));
    }

    @Override
    public JsonObject asJson() {
        JsonObject json = IRequirement.super.asJson();
        json.addProperty("actionType", this.mode.name());
        json.addProperty("amount", (Number)this.requirement);
        return json;
    }

    @Override
    @NotNull
    public Component getMissingComponentErrorMessage(IOType ioType) {
        return Component.translatable((String)String.format("component.missing.energy.%s", ioType.name().toLowerCase()));
    }

    @Override
    public boolean isComponentValid(EnergyComponent m, ICraftingContext context) {
        return this.getMode().equals(m.getIOType());
    }

    @Override
    @Generated
    public IOType getMode() {
        return this.mode;
    }

    @Override
    @Generated
    public PositionedRequirement getPosition() {
        return this.position;
    }
}

