/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement;

import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.capability.EffectHandler;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.codec.RegistrarCodec;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IDisplayInfo;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.EffectComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import es.degrassi.mmreborn.common.util.RomanNumber;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import org.jetbrains.annotations.NotNull;

public class RequirementEffect
implements IRequirement<EffectComponent, EffectHandler> {
    public static final NamedCodec<RequirementEffect> CODEC = NamedCodec.record(instance -> instance.group(RegistrarCodec.EFFECT.fieldOf("effect").forGetter(req -> (MobEffect)req.effect.value()), NamedCodec.INT.fieldOf("time").forGetter(req -> req.time), NamedCodec.INT.optionalFieldOf("level", 1).forGetter(req -> req.level), RegistrarCodec.ENTITY.listOf().optionalFieldOf("filter", new ArrayList()).forGetter(req -> req.filter)).apply((Applicative)instance, (effect, time, level, filter) -> new RequirementEffect((Holder<MobEffect>)BuiltInRegistries.MOB_EFFECT.wrapAsHolder(effect).getDelegate(), (int)time, (int)level, (List<EntityType<?>>)filter)), "Requirement Effect");
    private final Holder<MobEffect> effect;
    private final int time;
    private final int level;
    private final List<EntityType<?>> filter;
    private final PositionedRequirement position;

    public RequirementEffect(Holder<MobEffect> effect, int time, int level, List<EntityType<?>> filter) {
        this.effect = effect;
        this.time = time;
        this.level = level;
        this.filter = filter;
        this.position = new PositionedRequirement(0, 0);
    }

    @Override
    public RequirementType<RequirementEffect, EffectComponent, EffectHandler> getType() {
        return RequirementTypeRegistration.EFFECT.get();
    }

    @Override
    public ComponentType<EffectHandler> getComponentType() {
        return ComponentRegistration.COMPONENT_EFFECT.get();
    }

    @Override
    public IOType getMode() {
        return IOType.NONE;
    }

    @Override
    public boolean test(EffectComponent component, ICraftingContext context) {
        return true;
    }

    @Override
    public void gatherRequirements(IRequirementList<EffectComponent> list) {
        list.processEachTick(this::processTick);
    }

    public CraftingResult processTick(EffectComponent component, ICraftingContext context) {
        int time = (int)context.getPerTickIntegerModifiedValue(this.time, this);
        int level = Mth.clamp((int)((int)context.getPerTickIntegerModifiedValue(this.level, this) - 1), (int)0, (int)255);
        component.getContainerProvider().applyEffect(new MobEffectInstance(this.effect, time, level), entity -> this.filter.isEmpty() || this.filter.contains(entity.getType()));
        return CraftingResult.success();
    }

    @Override
    @NotNull
    public Component getMissingComponentErrorMessage(IOType ioType) {
        return Component.translatable((String)"component.missing.effect");
    }

    @Override
    public boolean isComponentValid(EffectComponent m, ICraftingContext context) {
        return true;
    }

    @Override
    public void getDefaultDisplayInfo(IDisplayInfo info, RecipeRequirement<?, ?, ?> requirement) {
        MutableComponent effect = Component.literal((String)((MobEffect)this.effect.value()).getDisplayName().getString()).withStyle(ChatFormatting.AQUA);
        MutableComponent level = this.level <= 0 ? Component.empty() : Component.literal((String)RomanNumber.toRoman(this.level)).withStyle(ChatFormatting.GOLD);
        info.addTooltip((Component)Component.translatable((String)"modular_machinery_reborn.jei.ingredient.effect.info.tick", (Object[])new Object[]{effect, level, this.time}));
        if (!this.filter.isEmpty()) {
            info.addTooltip((Component)Component.translatable((String)"modular_machinery_reborn.jei.ingredient.effect.info.whitelist").withStyle(ChatFormatting.AQUA));
            this.filter.forEach(type -> info.addTooltip((Component)Component.literal((String)"* ").append((Component)Component.translatable((String)type.getDescriptionId()))));
        }
        info.setItemIcon(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.HEALING));
    }

    @Override
    @Generated
    public PositionedRequirement getPosition() {
        return this.position;
    }
}

