/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.codec.NamedMapCodec;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.DurationComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class RequirementDuration
implements IRequirement<DurationComponent, Void> {
    public static final NamedMapCodec<RequirementDuration> CODEC = NamedCodec.record(instance -> instance.group(NamedCodec.intRange(1, Integer.MAX_VALUE).fieldOf("time").forGetter(RequirementDuration::getTime), PositionedRequirement.POSITION_CODEC.optionalFieldOf("position", new PositionedRequirement(0, 0)).forGetter(IRequirement::getPosition)).apply((Applicative)instance, RequirementDuration::new), "Duration requirement");
    public final int time;
    private final PositionedRequirement position;

    public RequirementDuration(int time, PositionedRequirement position) {
        this.position = position;
        this.time = time;
    }

    @Override
    public RequirementType<RequirementDuration, DurationComponent, Void> getType() {
        return RequirementTypeRegistration.SPEED.get();
    }

    @Override
    public ComponentType<Void> getComponentType() {
        return ComponentRegistration.COMPONENT_DURATION.get();
    }

    @Override
    public IOType getMode() {
        return IOType.INPUT;
    }

    @Override
    public boolean test(DurationComponent component, ICraftingContext context) {
        return true;
    }

    @Override
    public void gatherRequirements(IRequirementList<DurationComponent> list) {
    }

    @Override
    public JsonObject asJson() {
        JsonObject json = IRequirement.super.asJson();
        json.addProperty("time", (Number)this.time);
        return json;
    }

    @Override
    @NotNull
    public Component getMissingComponentErrorMessage(IOType ioType) {
        return Component.translatable((String)"component.missing.duration");
    }

    @Override
    public boolean isComponentValid(DurationComponent m, ICraftingContext context) {
        return this.getMode().equals(m.getIOType());
    }

    @Generated
    public int getTime() {
        return this.time;
    }

    @Override
    @Generated
    public PositionedRequirement getPosition() {
        return this.position;
    }
}

