/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.codec.DefaultCodecs;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IDisplayInfo;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.DimensionComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import java.util.List;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;

public class RequirementDimension
implements IRequirement<DimensionComponent, ResourceLocation> {
    public static final NamedCodec<RequirementDimension> CODEC = NamedCodec.record(instance -> instance.group(DefaultCodecs.RESOURCE_LOCATION.listOf().fieldOf("filter").forGetter(RequirementDimension::filter), NamedCodec.BOOL.optionalFieldOf("blacklist", false).forGetter(RequirementDimension::blacklist)).apply((Applicative)instance, RequirementDimension::new), "Dimension Requirement");
    private final PositionedRequirement position;
    private final List<ResourceLocation> filter;
    private final boolean blacklist;

    public RequirementDimension(List<ResourceLocation> filter, boolean blacklist) {
        this.filter = filter;
        this.blacklist = blacklist;
        this.position = new PositionedRequirement(0, 0);
    }

    public List<ResourceLocation> filter() {
        return this.filter;
    }

    public boolean blacklist() {
        return this.blacklist;
    }

    @Override
    public RequirementType<RequirementDimension, DimensionComponent, ResourceLocation> getType() {
        return RequirementTypeRegistration.DIMENSION.get();
    }

    @Override
    public ComponentType<ResourceLocation> getComponentType() {
        return ComponentRegistration.COMPONENT_DIMENSION.get();
    }

    @Override
    public IOType getMode() {
        return IOType.INPUT;
    }

    @Override
    public boolean test(DimensionComponent component, ICraftingContext context) {
        return this.filter.contains(component.getContainerProvider()) != this.blacklist;
    }

    @Override
    public void gatherRequirements(IRequirementList<DimensionComponent> list) {
    }

    @Override
    public JsonObject asJson() {
        JsonObject json = IRequirement.super.asJson();
        json.addProperty("blacklist", Boolean.valueOf(this.blacklist));
        JsonArray array = new JsonArray();
        this.filter.stream().map(ResourceLocation::toString).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        json.add("filter", (JsonElement)array);
        return json;
    }

    @Override
    @NotNull
    public Component getMissingComponentErrorMessage(IOType ioType) {
        return Component.translatable((String)"component.missing.dimension");
    }

    @Override
    public boolean isComponentValid(DimensionComponent m, ICraftingContext context) {
        return this.getMode().equals(m.getIOType());
    }

    @Override
    public void getDefaultDisplayInfo(IDisplayInfo info, RecipeRequirement<?, ?, ?> requirement) {
        StringBuilder dimensions = new StringBuilder();
        this.filter.forEach(dimension -> dimensions.append(dimension.toString()).append(","));
        int index = dimensions.lastIndexOf(",");
        if (index >= dimensions.length() - 1) {
            dimensions.deleteCharAt(index);
        }
        info.addTooltip((Component)Component.translatable((String)("modular_machinery_reborn.jei.ingredient.dimension." + this.blacklist()), (Object[])new Object[]{dimensions.toString()}));
        info.setSpriteIcon(InventoryMenu.BLOCK_ATLAS, ResourceLocation.withDefaultNamespace((String)"block/nether_portal"));
    }

    @Override
    @Generated
    public PositionedRequirement getPosition() {
        return this.position;
    }
}

