/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement;

import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IDisplayInfo;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.CommandComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class RequirementCommand
implements IRequirement<CommandComponent, Void> {
    public static final NamedCodec<RequirementCommand> CODEC = NamedCodec.record(instance -> instance.group(Phase.CODEC.optionalFieldOf("phase", Phase.END).forGetter(RequirementCommand::getPhase), NamedCodec.STRING.fieldOf("command").forGetter(RequirementCommand::getCommand), NamedCodec.INT.optionalFieldOf("permission_level", 2).forGetter(RequirementCommand::getPermissionLevel), NamedCodec.BOOL.optionalFieldOf("log", false).forGetter(RequirementCommand::isLog)).apply((Applicative)instance, RequirementCommand::new), "Requirement Command");
    private final Phase phase;
    private final String command;
    private final int permissionLevel;
    private final boolean log;

    @Override
    public RequirementType<RequirementCommand, CommandComponent, Void> getType() {
        return RequirementTypeRegistration.COMMAND.get();
    }

    @Override
    public ComponentType<Void> getComponentType() {
        return ComponentRegistration.COMPONENT_COMMAND.get();
    }

    @Override
    public IOType getMode() {
        return IOType.NONE;
    }

    @Override
    public boolean test(CommandComponent component, ICraftingContext context) {
        return true;
    }

    @Override
    public void gatherRequirements(IRequirementList<CommandComponent> list) {
        switch (this.phase.ordinal()) {
            case 0: {
                list.processOnStart(this::process);
                break;
            }
            case 2: {
                list.processOnEnd(this::process);
                break;
            }
            case 1: {
                list.processEachTick(this::process);
            }
        }
    }

    private CraftingResult process(CommandComponent component, ICraftingContext context) {
        component.sendCommand(this.command, this.permissionLevel, this.log);
        return CraftingResult.pass();
    }

    @Override
    public PositionedRequirement getPosition() {
        return new PositionedRequirement(0, 0);
    }

    @Override
    @NotNull
    public Component getMissingComponentErrorMessage(IOType ioType) {
        return Component.translatable((String)"component.missing.command");
    }

    @Override
    public boolean isComponentValid(CommandComponent m, ICraftingContext context) {
        return true;
    }

    @Override
    public void getDefaultDisplayInfo(IDisplayInfo info, RecipeRequirement<?, ?, ?> requirement) {
        info.setItemIcon(Items.COMMAND_BLOCK);
        Object[] objectArray = new Object[2];
        objectArray[0] = Component.literal((String)this.command).withStyle(ChatFormatting.AQUA);
        objectArray[1] = switch (this.phase.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "start";
            case 2 -> "end";
            case 1 -> "each tick";
        };
        info.addTooltip((Component)Component.translatable((String)"modular_machinery_reborn.jei.ingredient.command.info", (Object[])objectArray));
    }

    @Generated
    public Phase getPhase() {
        return this.phase;
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    @Generated
    public boolean isLog() {
        return this.log;
    }

    @Generated
    public RequirementCommand(Phase phase, String command, int permissionLevel, boolean log) {
        this.phase = phase;
        this.command = command;
        this.permissionLevel = permissionLevel;
        this.log = log;
    }

    public static enum Phase {
        START,
        EACH_TICK,
        END;

        public static final NamedCodec<Phase> CODEC;

        static {
            CODEC = NamedCodec.enumCodec(Phase.class);
        }
    }
}

