/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.modifier;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.codec.RegistrarCodec;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.common.crafting.modifier.AdditionRecipeModifier;
import es.degrassi.mmreborn.common.crafting.modifier.IRecipeModifier;
import es.degrassi.mmreborn.common.crafting.modifier.MultiplicationRecipeModifier;
import es.degrassi.mmreborn.common.crafting.modifier.RecipeModifierTargetEvent;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public abstract class RecipeModifier<R extends IRequirement<C, T>, C extends MachineComponent<T>, T>
implements IRecipeModifier<R, C, T> {
    public static final NamedCodec<RecipeModifier<?, ?, ?>> CODEC = NamedCodec.record(modifierInstance -> modifierInstance.group(RegistrarCodec.REQUIREMENT_NEW.fieldOf("requirement").forGetter(RecipeModifier::getRequirementType), IOType.CODEC.fieldOf("mode").forGetter(RecipeModifier::getMode), IRecipeModifier.OPERATION.CODEC.fieldOf("operation").forGetter(RecipeModifier::getOperation), NamedCodec.FLOAT.fieldOf("modifier").forGetter(RecipeModifier::getModifier), NamedCodec.FLOAT.optionalFieldOf("chance", Float.valueOf(1.0f)).forGetter(RecipeModifier::getChance), NamedCodec.FLOAT.optionalFieldOf("max", Float.valueOf(Float.POSITIVE_INFINITY)).forGetter(RecipeModifier::getMax), NamedCodec.FLOAT.optionalFieldOf("min", Float.valueOf(Float.NEGATIVE_INFINITY)).forGetter(RecipeModifier::getMin)).apply((Applicative)modifierInstance, RecipeModifier::create), "Recipe modifier");
    public static final RandomSource RAND = RandomSource.create();
    public final RequirementType<R, C, T> requirementType;
    public final IOType mode;
    public final float modifier;
    public final float chance;
    public final float max;
    public final float min;
    public final Component tooltip;

    public static RecipeModifier<?, ?, ?> create(RequirementType<?, ?, ?> requirement, IOType mode, IRecipeModifier.OPERATION operation, float modifier, float chance, float max, float min) {
        if (requirement == RequirementTypeRegistration.SPEED.get()) {
            mode = IOType.INPUT;
        }
        return switch (operation) {
            default -> throw new MatchException(null, null);
            case IRecipeModifier.OPERATION.ADDITION -> new AdditionRecipeModifier(requirement, mode, modifier, chance, max, min);
            case IRecipeModifier.OPERATION.MULTIPLICATION -> new MultiplicationRecipeModifier(requirement, mode, modifier, chance, max, min);
        };
    }

    protected RecipeModifier(RequirementType<R, C, T> requirementType, IOType mode, float modifier, float chance, float max, float min) {
        if (RecipeModifierTargetEvent.Blacklist.BLACKLIST.stream().anyMatch(c -> c.equals(requirementType))) {
            throw new UnsupportedOperationException("requirement type: " + String.valueOf(requirementType.getId()) + " is not a valid option for a Recipe Modifier");
        }
        this.requirementType = requirementType;
        this.mode = mode;
        this.modifier = modifier;
        this.chance = chance;
        this.max = max;
        this.min = min;
        this.tooltip = this.getDefaultTooltip();
    }

    @Override
    public boolean shouldApply(RequirementType<R, C, T> type, IOType mode) {
        return type == this.requirementType && mode == this.mode && (double)this.chance > RAND.nextDouble();
    }

    public abstract IRecipeModifier.OPERATION getOperation();

    public JsonObject asJson() {
        JsonObject json = new JsonObject();
        ResourceLocation key = ModularMachineryReborn.getRequirementRegistrar().getKey(this.requirementType);
        if (key == null) {
            key = ModularMachineryReborn.rl("speed");
        }
        json.addProperty("target", key.toString());
        json.addProperty("mode", this.mode.getSerializedName());
        json.addProperty("modifier", (Number)Float.valueOf(this.modifier));
        json.addProperty("operation", this.getOperation().toString());
        json.addProperty("chance", (Number)Float.valueOf(this.chance));
        return json;
    }

    public CompoundTag asTag() {
        CompoundTag tag = new CompoundTag();
        ResourceLocation key = ModularMachineryReborn.getRequirementRegistrar().getKey(this.requirementType);
        if (key == null) {
            key = ModularMachineryReborn.rl("speed");
        }
        tag.putString("target", key.toString());
        tag.putString("mode", this.mode.getSerializedName());
        tag.putFloat("modifier", this.modifier);
        tag.putString("operation", this.getOperation().toString());
        tag.putFloat("chance", this.chance);
        return tag;
    }

    protected String getTargetValue() {
        return Objects.requireNonNull(ModularMachineryReborn.getRequirementRegistrar().getKey(this.requirementType)).getPath();
    }

    @Generated
    public RequirementType<R, C, T> getRequirementType() {
        return this.requirementType;
    }

    @Generated
    public IOType getMode() {
        return this.mode;
    }

    @Generated
    public float getModifier() {
        return this.modifier;
    }

    @Generated
    public float getChance() {
        return this.chance;
    }

    @Generated
    public float getMax() {
        return this.max;
    }

    @Generated
    public float getMin() {
        return this.min;
    }

    @Override
    @Generated
    public Component getTooltip() {
        return this.tooltip;
    }
}

