/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.codec.DefaultCodecs;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.codec.NamedMapCodec;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.MachineRecipeSerializer;
import es.degrassi.mmreborn.common.crafting.helper.ProgressData;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedSizedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementEnergyPerTick;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.registration.RecipeRegistration;
import es.degrassi.mmreborn.common.util.MMRLogger;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MachineRecipe
implements Comparable<MachineRecipe>,
Recipe<RecipeInput> {
    public static final NamedMapCodec<MachineRecipeBuilder> CODEC = NamedCodec.record(instance -> instance.group(DefaultCodecs.RESOURCE_LOCATION.fieldOf("machine").forGetter(MachineRecipeBuilder::getMachine), NamedCodec.intRange(1, Integer.MAX_VALUE).fieldOf("time").forGetter(MachineRecipeBuilder::getTime), RecipeRequirement.CODEC.listOf().fieldOf("requirements").forGetter(MachineRecipeBuilder::getRequirements), RecipeRequirement.CODEC.listOf().optionalFieldOf("jeiRequirements", List.of()).forGetter(MachineRecipeBuilder::getJeiRequirements), NamedCodec.INT.optionalFieldOf("priority", 0).forGetter(MachineRecipeBuilder::getPrio), NamedCodec.BOOL.optionalFieldOf("hidden", false).forGetter(MachineRecipeBuilder::isHidden), NamedCodec.BOOL.optionalFieldOf("voidFailure", true).forGetter(MachineRecipeBuilder::isVoidF), NamedCodec.INT.optionalFieldOf("width", 256).forGetter(MachineRecipeBuilder::getWidth), NamedCodec.INT.optionalFieldOf("height", 256).forGetter(MachineRecipeBuilder::getHeight), NamedCodec.BOOL.optionalFieldOf("renderProgress", true).forGetter(MachineRecipeBuilder::isShouldRenderProgress), ProgressData.CODEC.optionalFieldOf("progressData", ProgressData.DEFAULT_PROGRESS).forGetter(MachineRecipeBuilder::getProgressData)).apply((Applicative)instance, MachineRecipeBuilder::new), "Machine recipe");
    private final ResourceLocation owningMachine;
    private final int tickTime;
    private final List<RecipeRequirement<?, ?, ?>> recipeRequirements = Lists.newArrayList();
    private final List<RecipeRequirement<?, ?, ?>> jeiRequirements = Lists.newArrayList();
    private final int configuredPriority;
    private final boolean voidPerTickFailure;
    private final ProgressData progressData;
    private final int width;
    private final int height;
    public final List<Component> textsToRender = Lists.newArrayList();
    public final List<Pair<PositionedSizedRequirement, Object>> chanceTexts = Lists.newArrayList();
    private final boolean shouldRenderProgress;
    private boolean modified = false;
    private boolean hidden = false;

    public MachineRecipe(ResourceLocation owningMachine, int tickTime, int configuredPriority, boolean voidPerTickFailure, int width, int height, boolean shouldRenderProgress, ProgressData progressData) {
        this.owningMachine = owningMachine;
        this.tickTime = tickTime;
        this.configuredPriority = configuredPriority;
        this.voidPerTickFailure = voidPerTickFailure;
        this.progressData = progressData;
        this.shouldRenderProgress = shouldRenderProgress;
        this.width = width;
        this.height = height;
    }

    public void hide(boolean hide) {
        this.hidden = hide;
        if (this.hidden) {
            MMRLogger.INSTANCE.info("Hiding recipe: {}", (Object)this);
        }
    }

    public ResourceLocation getOwningMachineIdentifier() {
        return this.owningMachine;
    }

    public List<RecipeRequirement<?, ?, ?>> getRequirements() {
        return this.recipeRequirements;
    }

    public void addRequirement(RecipeRequirement<?, ?, ?> requirement) {
        if (requirement.requirement() instanceof RequirementEnergyPerTick) {
            for (RecipeRequirement<?, ?, ?> req : this.getRequirements()) {
                if (!(req.requirement() instanceof RequirementEnergyPerTick) || req.requirement().getMode() != requirement.requirement().getMode()) continue;
                throw new IllegalStateException("Tried to add multiple energy requirements for the same ioType! Please only add one for each ioType!");
            }
        }
        if (requirement.isModified()) {
            this.setModified(true);
        }
        this.recipeRequirements.add(requirement);
    }

    public void addJeiRequirement(RecipeRequirement<?, ?, ?> requirement) {
        if (requirement.requirement() instanceof RequirementEnergyPerTick) {
            for (RecipeRequirement<?, ?, ?> req : this.getJeiRequirements()) {
                if (!(req.requirement() instanceof RequirementEnergyPerTick) || req.requirement().getMode() != requirement.requirement().getMode()) continue;
                throw new IllegalStateException("Tried to add multiple energy requirements for the same ioType! Please only add one for each ioType!");
            }
        }
        if (requirement.isModified()) {
            this.setModified(true);
        }
        this.jeiRequirements.add(requirement);
    }

    public int getRecipeTotalTickTime() {
        return this.tickTime;
    }

    public boolean doesCancelRecipeOnPerTickFailure() {
        return this.voidPerTickFailure;
    }

    @Nullable
    public DynamicMachine getOwningMachine() {
        return (DynamicMachine)ModularMachineryReborn.MACHINES.get((Object)this.getOwningMachineIdentifier());
    }

    @Override
    public int compareTo(MachineRecipe o) {
        return Integer.compare(this.buildWeight(), o.buildWeight());
    }

    private int buildWeight() {
        return this.configuredPriority;
    }

    public JsonObject asJson() {
        JsonObject json = new JsonObject();
        json.addProperty("owningMachine", this.owningMachine.toString());
        json.addProperty("tickTime", (Number)this.tickTime);
        JsonArray recipeRequirements = new JsonArray();
        this.recipeRequirements.forEach(req -> recipeRequirements.add((JsonElement)req.asJson()));
        JsonArray jeiRequirements = new JsonArray();
        this.jeiRequirements.forEach(req -> jeiRequirements.add((JsonElement)req.asJson()));
        json.add("recipeRequirements", (JsonElement)recipeRequirements);
        json.add("jeiRequirements", (JsonElement)jeiRequirements);
        json.addProperty("configuredPriority", (Number)this.configuredPriority);
        json.addProperty("voidPerTickFailure", Boolean.valueOf(this.voidPerTickFailure));
        json.addProperty("shouldRenderProgress", Boolean.valueOf(this.shouldRenderProgress));
        json.add("progressData", (JsonElement)this.progressData.asJson());
        json.addProperty("modifiedByAU", Boolean.valueOf(this.modified));
        json.addProperty("hidden", Boolean.valueOf(this.hidden));
        return json;
    }

    public String toString() {
        return this.asJson().toString();
    }

    public boolean matches(@NotNull RecipeInput container, @NotNull Level level) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput container, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registryAccess) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public MachineRecipeSerializer getSerializer() {
        return RecipeRegistration.RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistration.RECIPE_TYPE.get();
    }

    public List<RecipeRequirement<?, ?, ?>> getDisplayInfoRequirements() {
        if (this.getJeiRequirements().isEmpty()) {
            return this.getRequirements();
        }
        return this.getJeiRequirements();
    }

    @Generated
    public List<RecipeRequirement<?, ?, ?>> getRecipeRequirements() {
        return this.recipeRequirements;
    }

    @Generated
    public List<RecipeRequirement<?, ?, ?>> getJeiRequirements() {
        return this.jeiRequirements;
    }

    @Generated
    public int getConfiguredPriority() {
        return this.configuredPriority;
    }

    @Generated
    public boolean isVoidPerTickFailure() {
        return this.voidPerTickFailure;
    }

    @Generated
    public ProgressData getProgressData() {
        return this.progressData;
    }

    @Generated
    public int getWidth() {
        return this.width;
    }

    @Generated
    public int getHeight() {
        return this.height;
    }

    @Generated
    public List<Component> getTextsToRender() {
        return this.textsToRender;
    }

    @Generated
    public List<Pair<PositionedSizedRequirement, Object>> getChanceTexts() {
        return this.chanceTexts;
    }

    @Generated
    public boolean isShouldRenderProgress() {
        return this.shouldRenderProgress;
    }

    @Generated
    public boolean isModified() {
        return this.modified;
    }

    @Generated
    public boolean isHidden() {
        return this.hidden;
    }

    @Generated
    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Generated
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public static class MachineRecipeBuilder {
        private final ResourceLocation machine;
        private final ProgressData progressData;
        private final int time;
        private final int width;
        private final int height;
        private int prio;
        private boolean shouldRenderProgress;
        private final List<RecipeRequirement<?, ?, ?>> requirements;
        private final List<RecipeRequirement<?, ?, ?>> jeiRequirements;
        private boolean voidF;
        private boolean modified;
        private boolean hidden;

        public MachineRecipeBuilder(ResourceLocation machine, int time, int width, int height, ProgressData progressData) {
            this.requirements = Lists.newArrayList();
            this.jeiRequirements = Lists.newArrayList();
            this.machine = machine;
            this.time = time;
            this.progressData = progressData;
            this.width = width;
            this.height = height;
        }

        public void modified(boolean modified) {
            this.modified = modified;
        }

        public void withPriority(int prio) {
            this.prio = prio;
        }

        public void shouldVoidOnFailure(boolean v) {
            this.voidF = v;
        }

        public void shouldRenderProgress(boolean v) {
            this.shouldRenderProgress = v;
        }

        public void hide() {
            this.hidden = true;
        }

        public void addRequirement(RecipeRequirement<?, ?, ?> requirement) {
            this.requirements.add(requirement);
            if (requirement.isModified()) {
                this.modified(true);
            }
        }

        public MachineRecipeBuilder(ResourceLocation machine, int time, List<RecipeRequirement<?, ?, ?>> requirements, int prio, boolean hidden, boolean voidF, int width, int height, boolean shouldRenderProgress, ProgressData progressData) {
            this.machine = machine;
            this.time = time;
            this.requirements = requirements;
            this.jeiRequirements = Lists.newArrayList();
            this.prio = prio;
            this.voidF = voidF;
            this.progressData = progressData;
            this.shouldRenderProgress = shouldRenderProgress;
            this.width = width;
            this.height = height;
            this.hidden = hidden;
        }

        public MachineRecipeBuilder(ResourceLocation machine, int time, List<RecipeRequirement<?, ?, ?>> requirements, List<RecipeRequirement<?, ?, ?>> jeiRequirements, int prio, boolean hidden, boolean voidF, int width, int height, boolean shouldRenderProgress, ProgressData progressData) {
            this.machine = machine;
            this.time = time;
            this.requirements = requirements;
            this.jeiRequirements = jeiRequirements;
            this.prio = prio;
            this.voidF = voidF;
            this.hidden = hidden;
            this.progressData = progressData;
            this.shouldRenderProgress = shouldRenderProgress;
            this.width = width;
            this.height = height;
        }

        public MachineRecipeBuilder(MachineRecipe recipe) {
            this(recipe.getOwningMachineIdentifier(), recipe.tickTime, recipe.recipeRequirements, recipe.jeiRequirements, recipe.configuredPriority, recipe.hidden, recipe.voidPerTickFailure, recipe.width, recipe.height, recipe.shouldRenderProgress, recipe.progressData);
            this.modified(recipe.modified);
        }

        public MachineRecipe build() {
            try {
                MMRLogger.INSTANCE.debug("Building recipe...");
                MachineRecipe recipe = new MachineRecipe(this.machine, this.time, this.prio, this.voidF, this.width, this.height, this.shouldRenderProgress, this.progressData);
                this.requirements.forEach(recipe::addRequirement);
                this.jeiRequirements.forEach(recipe::addJeiRequirement);
                if (!recipe.modified) {
                    recipe.setModified(this.modified);
                }
                recipe.hide(this.hidden);
                MMRLogger.INSTANCE.debug("Finished building recipe {}", (Object)recipe);
                return recipe;
            }
            catch (Exception ex) {
                MMRLogger.INSTANCE.error("Error while building recipe for machine: {}", (Object)this.machine, (Object)ex);
                return null;
            }
        }

        public void addJeiRequirements(List<RecipeRequirement<?, ?, ?>> requirements) {
            this.jeiRequirements.addAll(requirements);
        }

        @Generated
        public ResourceLocation getMachine() {
            return this.machine;
        }

        @Generated
        public ProgressData getProgressData() {
            return this.progressData;
        }

        @Generated
        public int getTime() {
            return this.time;
        }

        @Generated
        public int getWidth() {
            return this.width;
        }

        @Generated
        public int getHeight() {
            return this.height;
        }

        @Generated
        public int getPrio() {
            return this.prio;
        }

        @Generated
        public boolean isShouldRenderProgress() {
            return this.shouldRenderProgress;
        }

        @Generated
        public List<RecipeRequirement<?, ?, ?>> getRequirements() {
            return this.requirements;
        }

        @Generated
        public List<RecipeRequirement<?, ?, ?>> getJeiRequirements() {
            return this.jeiRequirements;
        }

        @Generated
        public boolean isVoidF() {
            return this.voidF;
        }

        @Generated
        public boolean isModified() {
            return this.modified;
        }

        @Generated
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

