/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.block.prop;

import es.degrassi.mmreborn.common.block.prop.ConfigLoaded;
import java.util.Locale;
import net.minecraft.util.StringRepresentable;

public enum FuelTankSize implements ConfigLoaded,
StringRepresentable
{
    TINY(FuelTankSize.secondsToTicks(500L)),
    SMALL(FuelTankSize.secondsToTicks(1000L)),
    NORMAL(FuelTankSize.secondsToTicks(2500L)),
    REINFORCED(FuelTankSize.secondsToTicks(5000L)),
    BIG(FuelTankSize.secondsToTicks(7500L)),
    HUGE(FuelTankSize.secondsToTicks(10000L));

    public long burnTimeCapacity;
    public int stackSize;
    public final long defaultBurnTimeCapacity;
    public final int defaultStackSize;

    private FuelTankSize(long defaultBurnTimeCapacity) {
        this.defaultBurnTimeCapacity = defaultBurnTimeCapacity;
        this.defaultStackSize = 64;
    }

    public static FuelTankSize value(String value) {
        return switch (value.toUpperCase(Locale.ROOT)) {
            case "SMALL" -> SMALL;
            case "NORMAL" -> NORMAL;
            case "REINFORCED" -> REINFORCED;
            case "BIG" -> BIG;
            case "HUGE" -> HUGE;
            default -> TINY;
        };
    }

    private static long secondsToTicks(long seconds) {
        return seconds * 20L;
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

