/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.block.prop;

import es.degrassi.mmreborn.common.block.prop.ConfigLoaded;
import es.degrassi.mmreborn.common.entity.base.BlockEntitySynchronized;
import es.degrassi.mmreborn.common.network.server.component.SUpdateFluidComponentPacket;
import es.degrassi.mmreborn.common.util.HybridTank;
import java.util.Locale;
import lombok.Generated;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public enum FluidHatchSize implements StringRepresentable,
ConfigLoaded
{
    TINY(100),
    SMALL(400),
    NORMAL(1000),
    REINFORCED(2000),
    BIG(4500),
    HUGE(8000),
    LUDICROUS(16000),
    VACUUM(32000);

    public int size;
    public final int defaultConfigurationValue;

    private FluidHatchSize(int defaultConfigurationValue) {
        this.defaultConfigurationValue = defaultConfigurationValue;
    }

    public static FluidHatchSize value(String value) {
        return switch (value.toUpperCase(Locale.ROOT)) {
            case "SMALL" -> SMALL;
            case "NORMAL" -> NORMAL;
            case "REINFORCED" -> REINFORCED;
            case "BIG" -> BIG;
            case "HUGE" -> HUGE;
            case "LUDICROUS" -> LUDICROUS;
            case "VACUUM" -> VACUUM;
            default -> TINY;
        };
    }

    public HybridTank buildTank(BlockEntitySynchronized tileEntity, boolean canFill, boolean canDrain) {
        HybridTank tank = this.buildDefaultTank(tileEntity);
        return tank;
    }

    private HybridTank buildDefaultTank(final BlockEntitySynchronized tileEntity) {
        return new HybridTank(this, this.size){

            @Override
            protected void onContentsChanged() {
                super.onContentsChanged();
                tileEntity.markForUpdate();
            }

            public void setFluid(FluidStack stack) {
                super.setFluid(stack);
                Level level = tileEntity.getLevel();
                if (level instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(tileEntity.getBlockPos()), (CustomPacketPayload)new SUpdateFluidComponentPacket(this.getFluid(), tileEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                FluidStack stack = super.drain(maxDrain, action);
                Level level = tileEntity.getLevel();
                if (level instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(tileEntity.getBlockPos()), (CustomPacketPayload)new SUpdateFluidComponentPacket(this.getFluid(), tileEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                return stack;
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                FluidStack stack = super.drain(resource, action);
                Level level = tileEntity.getLevel();
                if (level instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(tileEntity.getBlockPos()), (CustomPacketPayload)new SUpdateFluidComponentPacket(this.getFluid(), tileEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                return stack;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                int fill = super.fill(resource, action);
                Level level = tileEntity.getLevel();
                if (level instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(tileEntity.getBlockPos()), (CustomPacketPayload)new SUpdateFluidComponentPacket(this.getFluid(), tileEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                return fill;
            }
        };
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    @Generated
    public int getSize() {
        return this.size;
    }
}

