/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.block.prop;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Map;

public interface ConfigLoaded {
    public static final Map<Class<? extends Enum<?>>, ValueSetter<?>> setters = Maps.newHashMap();

    public static <T extends Enum<T>> void add(Class<T> clazz, ValueSetter<T> consumer) {
        setters.put(clazz, consumer);
    }

    @SafeVarargs
    public static void add(Pair<Class<? extends Enum<?>>, ValueSetter<?>> ... consumers) {
        Arrays.asList(consumers).forEach(consumer -> setters.put((Class)consumer.getFirst(), (ValueSetter)consumer.getSecond()));
    }

    public static void load() {
        setters.forEach(ConfigLoaded::loadFromConfig);
    }

    public static <T extends Enum<T>> void loadFromConfig(Class<?> clazz, ValueSetter<T> consumer) {
        for (Enum value : (Enum[])clazz.getEnumConstants()) {
            consumer.set(value);
        }
    }

    public static interface ValueSetter<T extends Enum<T>> {
        public void set(T var1);
    }
}

