/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.block;

import es.degrassi.mmreborn.client.container.ParallelHatchContainer;
import es.degrassi.mmreborn.common.block.BlockMachineComponent;
import es.degrassi.mmreborn.common.block.prop.ParallelHatchSize;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.entity.ParallelHatchEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParallelHatchBlock
extends BlockMachineComponent {
    protected final ParallelHatchSize type;

    public ParallelHatchBlock(ParallelHatchSize type) {
        super(BlockBehaviour.Properties.of().dynamicShape().noOcclusion().strength(2.0f, 10.0f).sound(SoundType.METAL));
        this.type = type;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.parallelhatch.size", (Object[])new Object[]{this.type.max}).withStyle(ChatFormatting.GRAY));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.sidedSuccess((boolean)true);
        }
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof ParallelHatchEntity) {
            ParallelHatchEntity entity = (ParallelHatchEntity)te;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                ParallelHatchContainer.open(sp, entity);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new ParallelHatchEntity(blockPos, blockState, this.type);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ParallelHatchEntity) {
            ParallelHatchEntity entity = (ParallelHatchEntity)blockEntity;
            if (level instanceof ServerLevel) {
                if (entity.getController() != null) {
                    MachineControllerEntity controller = entity.getController();
                    super.onBlockExploded(state, level, pos, explosion);
                    controller.getComponentManager().updateComponents();
                    controller.getProcessor().updateActiveCores(1);
                }
            } else {
                super.onBlockExploded(state, level, pos, explosion);
            }
        } else {
            super.onBlockExploded(state, level, pos, explosion);
        }
    }

    @Override
    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ParallelHatchEntity) {
            ParallelHatchEntity entity = (ParallelHatchEntity)blockEntity;
            if (level instanceof ServerLevel) {
                if (entity.getController() != null) {
                    MachineControllerEntity controller = entity.getController();
                    super.onRemove(state, level, pos, newState, movedByPiston);
                    controller.getComponentManager().updateComponents();
                    controller.getProcessor().updateActiveCores(1);
                } else {
                    super.onRemove(state, level, pos, newState, movedByPiston);
                }
            } else {
                super.onRemove(state, level, pos, newState, movedByPiston);
            }
        } else {
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ParallelHatchEntity) {
            ParallelHatchEntity entity = (ParallelHatchEntity)blockEntity;
            if (level instanceof ServerLevel) {
                if (entity.getController() != null) {
                    MachineControllerEntity controller = entity.getController();
                    boolean toReturn = super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
                    controller.getComponentManager().updateComponents();
                    controller.getProcessor().updateActiveCores(1);
                    return toReturn;
                }
                return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
            }
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void onDestroyedByPushReaction(BlockState state, Level level, BlockPos pos, Direction pushDirection, FluidState fluid) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ParallelHatchEntity) {
            ParallelHatchEntity entity = (ParallelHatchEntity)blockEntity;
            if (level instanceof ServerLevel) {
                if (entity.getController() != null) {
                    MachineControllerEntity controller = entity.getController();
                    super.onDestroyedByPushReaction(state, level, pos, pushDirection, fluid);
                    controller.getComponentManager().updateComponents();
                    controller.getProcessor().updateActiveCores(1);
                } else {
                    super.onDestroyedByPushReaction(state, level, pos, pushDirection, fluid);
                }
            } else {
                super.onDestroyedByPushReaction(state, level, pos, pushDirection, fluid);
            }
        } else {
            super.onDestroyedByPushReaction(state, level, pos, pushDirection, fluid);
        }
    }
}

