/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.block;

import es.degrassi.mmreborn.client.ModularMachineryRebornClient;
import es.degrassi.mmreborn.common.block.BlockMachineComponent;
import es.degrassi.mmreborn.common.block.BlockTickEntity;
import es.degrassi.mmreborn.common.block.prop.EffectDispenserSize;
import es.degrassi.mmreborn.common.entity.EffectDispenserEntity;
import es.degrassi.mmreborn.common.util.RedstoneHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEffectDispenser
extends BlockMachineComponent
implements BlockTickEntity {
    private final EffectDispenserSize size;

    public BlockEffectDispenser(EffectDispenserSize size) {
        super(BlockBehaviour.Properties.of().strength(2.0f, 10.0f).sound(SoundType.METAL).requiresCorrectToolForDrops().dynamicShape().noOcclusion());
        this.size = size;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (!ModularMachineryRebornClient.shouldAddParticles(random)) {
            return;
        }
        if (this.size.interdimensional || !this.size.showParticles) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof EffectDispenserEntity) {
            EffectDispenserEntity entity = (EffectDispenserEntity)blockEntity;
            entity.getEffect().ifPresent(effect -> {
                ParticleOptions particle = effect.getParticleOptions();
                AABB bb = new AABB(pos).inflate((double)this.size.radius).setMaxY((double)pos.getY()).setMinY((double)pos.getY());
                for (double i = bb.minX; i <= bb.maxX; i += 1.0) {
                    for (double j = bb.minY; j <= bb.maxY; j += 1.0) {
                        for (double k = bb.minZ; k <= bb.maxZ; k += 1.0) {
                            ModularMachineryRebornClient.createParticle(particle, new BlockPos((int)i, (int)j, (int)k));
                        }
                    }
                }
            });
        }
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        return RedstoneHelper.getRedstoneLevel(pLevel.getBlockEntity(pPos));
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new EffectDispenserEntity(blockPos, blockState, this.size);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (this.size.interdimensional) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.effectdispenser.interdimensional").withStyle(ChatFormatting.GRAY));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.effectdispenser.radius", (Object[])new Object[]{this.size.radius}).withStyle(ChatFormatting.GRAY));
        }
    }
}

