/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.block;

import com.mojang.serialization.MapCodec;
import es.degrassi.mmreborn.common.block.BlockMachineComponent;
import java.util.Locale;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BlockCasing
extends BlockMachineComponent {
    private final CasingType casingType;
    public static final MapCodec<BlockMachineComponent> CODEC = BlockCasing.simpleCodec(props -> new BlockMachineComponent((BlockBehaviour.Properties)props){});

    public BlockCasing(CasingType type) {
        super(BlockBehaviour.Properties.of().strength(2.0f, 10.0f).sound(SoundType.METAL).requiresCorrectToolForDrops().dynamicShape().noOcclusion());
        this.casingType = type;
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    protected boolean skipRendering(BlockState state, BlockState adjacentState, Direction direction) {
        Block block = adjacentState.getBlock();
        if (block instanceof BlockCasing) {
            BlockCasing bc = (BlockCasing)block;
            block = state.getBlock();
            if (block instanceof BlockCasing) {
                BlockCasing bc1 = (BlockCasing)block;
                if (adjacentState.getRenderShape() == state.getRenderShape()) {
                    return bc.getCasingType() == bc1.getCasingType();
                }
            }
        }
        return super.skipRendering(state, adjacentState, direction);
    }

    protected VoxelShape getVisualShape(BlockState p_309057_, BlockGetter p_308936_, BlockPos p_308956_, CollisionContext p_309006_) {
        return Shapes.empty();
    }

    @Generated
    public CasingType getCasingType() {
        return this.casingType;
    }

    public static enum CasingType implements StringRepresentable
    {
        PLAIN,
        VENT,
        FIREBOX,
        GEARBOX,
        REINFORCED,
        CIRCUITRY;


        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase();
        }

        public static CasingType value(String name) {
            return switch (name.toLowerCase(Locale.ROOT)) {
                case "vent" -> VENT;
                case "firebox" -> FIREBOX;
                case "gearbox" -> GEARBOX;
                case "reinforced" -> REINFORCED;
                case "circuitry" -> CIRCUITRY;
                default -> PLAIN;
            };
        }
    }
}

