/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.util;

import es.degrassi.mmreborn.common.data.config.EnergyHatchConfig;
import lombok.Generated;
import net.minecraft.util.Mth;

public class EnergyDisplayUtil {
    public static boolean displayFETooltip = true;
    public static boolean displayIC2EUTooltip = true;
    public static EnergyType type = EnergyType.FE;

    public static void loadFromConfig() {
        displayFETooltip = (Boolean)EnergyHatchConfig.get().energy_displayFETooltip.get();
        displayIC2EUTooltip = (Boolean)EnergyHatchConfig.get().energy_displayIC2EUTooltip.get();
        type = (EnergyType)((Object)EnergyHatchConfig.get().energy_type.get());
    }

    public static enum EnergyType {
        FE(1.0),
        IC2_EU(0.25);

        private final double multiplier;
        private final String unlocalizedFormat;

        private EnergyType(double multiplier) {
            this.multiplier = multiplier;
            this.unlocalizedFormat = "tooltip.energy.type." + this.name().toLowerCase();
        }

        public long formatEnergyForDisplay(long energy) {
            return Mth.lfloor((double)((double)energy * this.multiplier));
        }

        public static EnergyType getType(String configValue) {
            EnergyType type = FE;
            try {
                type = EnergyType.valueOf(configValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return type;
        }

        @Generated
        public String getUnlocalizedFormat() {
            return this.unlocalizedFormat;
        }
    }
}

