/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.widget.tabs;

import es.degrassi.mmreborn.client.screen.widget.ItemOrIconButton;
import es.degrassi.mmreborn.client.screen.widget.tabs.TabGroupWidget;
import es.degrassi.mmreborn.client.screen.widget.tabs.TabWidget;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
public class VerticalTabGroupWidget
extends TabGroupWidget {
    public VerticalTabGroupWidget(int x, int y) {
        super(x, y, 0, 0, (Component)Component.empty());
    }

    @Override
    public int getWidth() {
        return this.tabs.stream().mapToInt(TabWidget::getWidth).max().orElse(1);
    }

    @Override
    public int getHeight() {
        return this.tabs.stream().mapToInt(TabWidget::getHeight).sum();
    }

    @Override
    public VerticalTabGroupWidget addTab(TabWidget tab) {
        return this.addTab(0, 0, tab);
    }

    @Override
    public VerticalTabGroupWidget addTab(int xOffset, int yOffset, TabWidget tab) {
        tab.setY(this.lastY.getAndAdd(tab.getHeight() + yOffset));
        tab.setX(this.getX() + xOffset);
        this.tabs.add(tab);
        return this;
    }

    @Override
    public VerticalTabGroupWidget addTab(ItemOrIconButton icon, @Nullable TabWidget.OnClick action) {
        return this.addTab(0, 0, icon, action);
    }

    @Override
    public VerticalTabGroupWidget addTab(int xOffset, int yOffset, ItemOrIconButton icon, @Nullable TabWidget.OnClick action) {
        TabWidget tab = new TabWidget(this.getX() + xOffset, this.lastY.get() + yOffset, icon, action);
        this.lastY.getAndAdd(tab.getHeight() + yOffset);
        return this.addTab(tab);
    }

    @Override
    public VerticalTabGroupWidget addTab(ItemOrIconButton icon) {
        return this.addTab(0, 0, icon);
    }

    @Override
    public VerticalTabGroupWidget addTab(int xOffset, int yOffset, ItemOrIconButton icon) {
        TabWidget tab = new TabWidget(this.getX() + xOffset, this.lastY.get() + yOffset, icon);
        this.lastY.getAndAdd(tab.getHeight() + yOffset);
        return this.addTab(tab);
    }
}

