/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.widget.tabs;

import es.degrassi.mmreborn.client.screen.widget.ItemOrIconButton;
import es.degrassi.mmreborn.client.screen.widget.tabs.HorizontalTabGroupWidget;
import es.degrassi.mmreborn.client.screen.widget.tabs.TabWidget;
import es.degrassi.mmreborn.client.screen.widget.tabs.TopTabWidget;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TopTabGroupWidget
extends HorizontalTabGroupWidget {
    private final AtomicInteger lastX = new AtomicInteger();

    public TopTabGroupWidget(int x, int y) {
        super(x, y);
        this.lastX.set(x);
    }

    public TopTabGroupWidget addTab(TopTabWidget tab) {
        return this.addTab(0, 0, tab);
    }

    public TopTabGroupWidget addTab(int xOffset, int yOffset, TopTabWidget tab) {
        tab.setX(this.lastX.getAndAdd(tab.getWidth() + xOffset));
        tab.setY(this.getY() + yOffset);
        this.tabs.add(tab);
        return this;
    }

    @Override
    public TopTabGroupWidget addTab(ItemOrIconButton icon, @Nullable TabWidget.OnClick action) {
        return this.addTab(0, 0, icon, action);
    }

    @Override
    public TopTabGroupWidget addTab(int xOffset, int yOffset, ItemOrIconButton icon, @Nullable TabWidget.OnClick action) {
        TopTabWidget tab = new TopTabWidget(this.lastX.get() + xOffset, this.getY() + yOffset, icon, action);
        this.lastX.getAndAdd(tab.getWidth() + xOffset);
        return this.addTab(tab);
    }

    @Override
    public TopTabGroupWidget addTab(ItemOrIconButton icon) {
        return this.addTab(0, 0, icon);
    }

    @Override
    public TopTabGroupWidget addTab(int xOffset, int yOffset, ItemOrIconButton icon) {
        TopTabWidget tab = new TopTabWidget(this.lastX.get() + xOffset, this.getY() + yOffset, icon);
        this.lastX.getAndAdd(tab.getWidth() + xOffset);
        return this.addTab(tab);
    }
}

