/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.widget.tabs;

import com.mojang.datafixers.util.Either;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.client.screen.widget.ItemOrIconButton;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

@ParametersAreNonnullByDefault
public class TabWidget
extends AbstractWidget {
    private static final ResourceLocation TAB = ModularMachineryReborn.rl("textures/gui/widget/base_tab_top.png");
    private static final ResourceLocation TAB_HOVERED = ModularMachineryReborn.rl("textures/gui/widget/base_tab_hovered_top.png");
    private final ItemOrIconButton iconButton;
    @Nullable
    private final OnClick onClick;

    public TabWidget(int x, int y, @Nullable ItemOrIconButton icon, @Nullable OnClick onClick) {
        super(x, y, 0, 0, (Component)Component.empty());
        this.iconButton = icon;
        this.onClick = onClick;
    }

    public TabWidget(int x, int y, @Nullable ItemOrIconButton icon) {
        this(x, y, icon, null);
    }

    public ResourceLocation getTab() {
        return TAB;
    }

    public ResourceLocation getTabHovered() {
        return TAB_HOVERED;
    }

    public int getWidth() {
        return TextureSizeHelper.getWidth(this.getTab());
    }

    public int getHeight() {
        return TextureSizeHelper.getHeight(this.getTab());
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation tab = this.isHoveredOrFocused() ? this.getTabHovered() : this.getTab();
        int x = this.getX();
        int y = this.getY();
        int width = TextureSizeHelper.getWidth(tab);
        int height = TextureSizeHelper.getHeight(tab);
        this.width = width;
        this.height = height;
        guiGraphics.blit(tab, x, y, 0.0f, 0.0f, width, height, width, height);
        if (this.getIconButton() != null) {
            this.getIconButton().setDisableBackground(true);
            this.getIconButton().setPosition(5 + x, 5 + y);
            this.getIconButton().renderTooltip(false);
            this.getIconButton().renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    protected boolean clicked(double mouseX, double mouseY) {
        return this.isMouseOver(mouseX, mouseY);
    }

    public void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        if (this.getIconButton() != null) {
            this.getIconButton().renderTooltip(guiGraphics, x, y);
        }
    }

    public void onClick(double mouseX, double mouseY, int button) {
        if (this.onClick != null) {
            this.onClick.onClick(mouseX, mouseY, button);
        }
        if (this.getIconButton() != null) {
            this.getIconButton().onClick(mouseX, mouseY, button);
        }
    }

    public void gatherComponents(List<Either<FormattedText, TooltipComponent>> components) {
    }

    public Rect2i getTooltipArea() {
        return new Rect2i(this.getX(), this.getY(), this.getWidth() - 5, this.getHeight());
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.getTooltipArea().contains((int)mouseX, (int)mouseY);
    }

    @Generated
    public ItemOrIconButton getIconButton() {
        return this.iconButton;
    }

    public static interface OnClick {
        public void onClick(double var1, double var3, int var5);
    }
}

